/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.changelog;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class PerforceChangesConsumer
extends AbstractConsumer {
    private List entries;
    private RE revisionRegexp;
    private static final String PATTERN = "^Change (\\d+) on (.*) by (.*)@";

    public PerforceChangesConsumer(ScmLogger logger) {
        block2: {
            super(logger);
            this.entries = new ArrayList();
            try {
                this.revisionRegexp = new RE(PATTERN);
            }
            catch (RESyntaxException ignored) {
                if (!this.getLogger().isErrorEnabled()) break block2;
                this.getLogger().error("Could not create regexp to parse perforce log file", (Throwable)ignored);
            }
        }
    }

    public List getChanges() throws ScmException {
        return this.entries;
    }

    public void consumeLine(String line) {
        if (this.revisionRegexp.match(line)) {
            this.entries.add(this.revisionRegexp.getParen(1));
        }
    }
}

