/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.unedit;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.unedit.AbstractUnEditCommand;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.unedit.StarteamUnEditConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamUnEditCommand
extends AbstractUnEditCommand
implements StarteamCommand {
    protected ScmResult executeUnEditCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamUnEditConsumer consumer = new StarteamUnEditConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        File[] editFiles = fileSet.getFiles();
        if (editFiles.length == 0) {
            Commandline cl = StarteamUnEditCommand.createCommandLine(repository, fileSet.getBasedir());
            int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
            if (exitCode != 0) {
                return new UnEditScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
            }
        } else {
            for (int i = 0; i < editFiles.length; ++i) {
                Commandline cl = StarteamUnEditCommand.createCommandLine(repository, editFiles[i]);
                int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
                if (exitCode == 0) continue;
                return new UnEditScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
            }
        }
        return new UnEditScmResult(null, consumer.getUnEditFiles());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, File dirOrFile) {
        Commandline cl = StarteamCommandLineUtils.createStarteamBaseCommandLine("lck", dirOrFile, repo);
        cl.createArgument().setValue("-u");
        if (dirOrFile.isDirectory()) {
            cl.createArgument().setValue("-is");
        } else {
            cl.createArgument().setValue(dirOrFile.getName());
        }
        return cl;
    }
}

