/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.update;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.changelog.SvnChangeLogCommand;
import org.apache.maven.scm.provider.svn.svnexe.command.update.SvnUpdateConsumer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnUpdateCommand
extends AbstractUpdateCommand
implements SvnCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag) throws ScmException {
        int exitCode;
        Commandline cl = SvnUpdateCommand.createCommandLine((SvnScmProviderRepository)repo, fileSet.getBasedir(), tag);
        SvnUpdateConsumer consumer = new SvnUpdateConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            exitCode = SvnCommandLineUtils.execute(cl, consumer, stderr, this.getLogger());
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new UpdateScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new UpdateScmResultWithRevision(cl.toString(), consumer.getUpdatedFiles(), String.valueOf(consumer.getRevision()));
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String tag) {
        if (tag != null && StringUtils.isEmpty((String)tag.trim())) {
            tag = null;
        }
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        if (tag == null || SvnTagBranchUtils.isRevisionSpecifier((String)tag)) {
            cl.createArgument().setValue("update");
            if (tag != null) {
                cl.createArgument().setValue("-r");
                cl.createArgument().setValue(tag);
            }
        } else {
            cl.createArgument().setValue("switch");
            cl.createArgument().setValue(SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (String)tag));
            cl.createArgument().setValue(workingDirectory.getAbsolutePath());
        }
        return cl;
    }

    protected ChangeLogCommand getChangeLogCommand() {
        SvnChangeLogCommand command = new SvnChangeLogCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

