/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.checkout;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.svn.svnexe.command.AbstractFileCheckingConsumer;

public class SvnCheckOutConsumer
extends AbstractFileCheckingConsumer {
    private static final String CHECKED_OUT_REVISION_TOKEN = "Checked out revision";

    public SvnCheckOutConsumer(ScmLogger logger, File workingDirectory) {
        super(logger, workingDirectory);
    }

    protected void parseLine(String line) {
        ScmFileStatus status;
        String statusString = line.substring(0, 1);
        String file = line.substring(3).trim();
        if (line.startsWith(CHECKED_OUT_REVISION_TOKEN)) {
            String revisionString = line.substring(CHECKED_OUT_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (statusString.equals("A")) {
            status = ScmFileStatus.ADDED;
        } else if (statusString.equals("U")) {
            status = ScmFileStatus.UPDATED;
        } else {
            return;
        }
        this.addFile(new ScmFile(file, status));
    }

    public List getCheckedOutFiles() {
        return this.getFiles();
    }
}

