/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.cli;

import java.io.InputStream;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CommandLineManager
extends CommandLineUtils
implements LogEnabled {
    private Logger logger;

    public StreamConsumer newDebugStreamConsumer() {
        return new StreamConsumer(){

            public void consumeLine(String line) {
                if (CommandLineManager.this.getLogger().isDebugEnabled()) {
                    CommandLineManager.this.getLogger().debug(line);
                }
            }
        };
    }

    public StreamConsumer newInfoStreamConsumer() {
        return new StreamConsumer(){

            public void consumeLine(String line) {
                if (CommandLineManager.this.getLogger().isInfoEnabled()) {
                    CommandLineManager.this.getLogger().info(line);
                }
            }
        };
    }

    public int execute(Commandline cli, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + StringUtils.join((Object[])cli.getShellCommandline(), (String)" "));
        }
        return CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)systemOut, (StreamConsumer)systemErr);
    }

    public int execute(Commandline cli, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + StringUtils.join((Object[])cli.getShellCommandline(), (String)" "));
        }
        return CommandLineUtils.executeCommandLine((Commandline)cli, (InputStream)systemIn, (StreamConsumer)systemOut, (StreamConsumer)systemErr);
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(0, "CommandLineManager::internal");
        }
        return this.logger;
    }

    public void enableLogging(Logger log) {
        this.logger = log;
    }
}

