/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang.time.DateUtils;
import org.apache.maven.project.MavenProject;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.DefaultProjectFileSystem;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.ProjectConfiguration;

public class MavenProjectBuilder {
    private DatabaseSession databaseSession;

    public MavenProjectBuilder(DatabaseSession databaseSession) {
        this.databaseSession = databaseSession;
    }

    public Project create(MavenProject pom) {
        Configuration configuration = this.getStartupConfiguration(pom);
        return new Project(this.loadProjectKey(pom), this.loadProjectBranch(configuration), pom.getName()).setPom(pom).setDescription(pom.getDescription()).setPackaging(pom.getPackaging());
    }

    Configuration getStartupConfiguration(MavenProject pom) {
        CompositeConfiguration configuration = new CompositeConfiguration();
        configuration.addConfiguration((Configuration)new SystemConfiguration());
        configuration.addConfiguration((Configuration)new EnvironmentConfiguration());
        configuration.addConfiguration((Configuration)new MapConfiguration((Map)pom.getModel().getProperties()));
        return configuration;
    }

    String loadProjectKey(MavenProject pom) {
        return pom.getGroupId() + ":" + pom.getArtifactId();
    }

    String loadProjectBranch(Configuration configuration) {
        return configuration.getString("sonar.branch", configuration.getString("branch"));
    }

    public void configure(Project project) {
        ProjectConfiguration projectConfiguration = new ProjectConfiguration(this.databaseSession, project);
        this.configure(project, (Configuration)projectConfiguration);
    }

    void configure(Project project, Configuration projectConfiguration) {
        Date analysisDate = this.loadAnalysisDate(projectConfiguration);
        project.setConfiguration(projectConfiguration).setExclusionPatterns(MavenProjectBuilder.loadExclusionPatterns(projectConfiguration)).setAnalysisDate(analysisDate).setLatestAnalysis(this.isLatestAnalysis(project.getKey(), analysisDate)).setAnalysisVersion(this.loadAnalysisVersion(projectConfiguration, project.getPom())).setAnalysisType(this.loadAnalysisType(projectConfiguration)).setLanguageKey(this.loadLanguageKey(projectConfiguration)).setFileSystem((ProjectFileSystem)new DefaultProjectFileSystem(project));
    }

    static String[] loadExclusionPatterns(Configuration configuration) {
        String[] exclusionPatterns = configuration.getStringArray("sonar.exclusions");
        if (exclusionPatterns == null) {
            exclusionPatterns = new String[]{};
        }
        return exclusionPatterns;
    }

    boolean isLatestAnalysis(String projectKey, Date analysisDate) {
        ResourceModel persistedProject = (ResourceModel)this.databaseSession.getSingleResult(ResourceModel.class, new Object[]{"key", projectKey, "enabled", true});
        if (persistedProject != null) {
            Snapshot lastSnapshot = (Snapshot)this.databaseSession.getSingleResult(Snapshot.class, new Object[]{"resourceId", persistedProject.getId(), "last", true});
            return lastSnapshot == null || lastSnapshot.getCreatedAt().before(analysisDate);
        }
        return true;
    }

    Date loadAnalysisDate(Configuration configuration) {
        String formattedDate = configuration.getString("sonar.projectDate");
        if (formattedDate == null) {
            return new Date();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = DateUtils.setHours((Date)format.parse(formattedDate), (int)0);
            return DateUtils.setMinutes((Date)date, (int)1);
        }
        catch (ParseException e) {
            throw new SonarException("The property sonar.projectDate does not respect the format yyyy-MM-dd (for example 2008-05-23) : " + formattedDate, (Throwable)e);
        }
    }

    Project.AnalysisType loadAnalysisType(Configuration configuration) {
        String value = configuration.getString("sonar.dynamicAnalysis");
        if (value == null) {
            return configuration.getBoolean("sonar.light", false) ? Project.AnalysisType.STATIC : Project.AnalysisType.DYNAMIC;
        }
        if ("true".equals(value)) {
            return Project.AnalysisType.DYNAMIC;
        }
        if ("reuseReports".equals(value)) {
            return Project.AnalysisType.REUSE_REPORTS;
        }
        return Project.AnalysisType.STATIC;
    }

    String loadAnalysisVersion(Configuration configuration, MavenProject pom) {
        String version = configuration.getString("sonar.projectVersion");
        if (version == null && pom != null) {
            version = pom.getVersion();
        }
        return version;
    }

    String loadLanguageKey(Configuration configuration) {
        return configuration.getString("sonar.language", "java");
    }
}

