/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.List;
import java.util.Properties;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.FileFilter;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.database.daos.MeasuresDao;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.DefaultProjectFileSystem;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.DefaultRulesManager;
import org.sonar.api.utils.IocContainer;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.CheckProfileProvider;
import org.sonar.batch.DefaultSensorContext;
import org.sonar.batch.DefaultTimeMachine;
import org.sonar.batch.ProfileProvider;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.components.PastViolationsLoader;
import org.sonar.batch.components.TimeMachineConfiguration;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.phases.Phases;
import org.sonar.core.components.DefaultModelFinder;
import org.sonar.jpa.dao.AsyncMeasuresDao;
import org.sonar.jpa.dao.AsyncMeasuresService;
import org.sonar.jpa.dao.DaoFacade;
import org.sonar.jpa.dao.ProfilesDao;
import org.sonar.jpa.dao.RulesDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBatch {
    private MutablePicoContainer globalContainer;
    private MutablePicoContainer batchContainer;

    public ProjectBatch(MutablePicoContainer container) {
        this.globalContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DefaultIndex index, Project project) {
        try {
            this.startChildContainer(index, project);
            ((Phases)this.batchContainer.getComponent(Phases.class)).execute(project);
        }
        finally {
            this.stop();
        }
    }

    public void startChildContainer(DefaultIndex index, Project project) {
        this.batchContainer = this.globalContainer.makeChildContainer();
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)project);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)project.getPom());
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ProjectClasspath.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)project.getConfiguration());
        ((BatchPluginRepository)((Object)this.batchContainer.getComponent(BatchPluginRepository.class))).registerPlugins(this.batchContainer);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DaoFacade.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(RulesDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)((DefaultResourcePersister)this.globalContainer.getComponent(DefaultResourcePersister.class)).getSnapshot((Resource)project));
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(org.sonar.api.database.daos.RulesDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(MeasuresDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ProfilesDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(AsyncMeasuresDao.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(AsyncMeasuresService.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultRulesManager.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultSensorContext.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(Languages.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(BatchExtensionDictionnary.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultTimeMachine.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ViolationFilters.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(ResourceFilters.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(DefaultModelFinder.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(TimeMachineConfiguration.class);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent(PastViolationsLoader.class);
        this.batchContainer.addAdapter((ComponentAdapter)new ProfileProvider());
        this.batchContainer.addAdapter((ComponentAdapter)new CheckProfileProvider());
        this.loadCoreComponents(this.batchContainer);
        this.batchContainer.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)new IocContainer(this.batchContainer));
        this.batchContainer.start();
        this.prepareProject(project, index);
    }

    private void prepareProject(Project project, DefaultIndex index) {
        Language language = this.getComponent(Languages.class).get(project.getLanguageKey());
        if (language == null) {
            throw new SonarException("Language with key '" + project.getLanguageKey() + "' not found");
        }
        project.setLanguage(language);
        index.setCurrentProject(project, this.getComponent(ResourceFilters.class), this.getComponent(ViolationFilters.class), this.getComponent(RulesProfile.class));
        List fileFilters = this.batchContainer.getComponents(FileFilter.class);
        ((DefaultProjectFileSystem)project.getFileSystem()).addFileFilters(fileFilters);
    }

    private void loadCoreComponents(MutablePicoContainer container) {
        container.as(new Properties[]{Characteristics.CACHE}).addComponent(Phases.class);
        for (Class clazz : Phases.getPhaseClasses()) {
            container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)clazz);
        }
        for (Metric metric : CoreMetrics.getMetrics()) {
            container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)metric.getKey(), (Object)metric, new Parameter[0]);
        }
        for (Metrics metricRepo : container.getComponents(Metrics.class)) {
            for (Metric metric : metricRepo.getMetrics()) {
                container.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)metric.getKey(), (Object)metric, new Parameter[0]);
            }
        }
    }

    private void stop() {
        if (this.batchContainer != null) {
            try {
                this.globalContainer.removeChildContainer((PicoContainer)this.batchContainer);
                this.batchContainer.stop();
                this.batchContainer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public <T> T getComponent(Class<T> clazz) {
        if (this.batchContainer != null) {
            return (T)this.batchContainer.getComponent(clazz);
        }
        return (T)this.globalContainer.getComponent(clazz);
    }
}

