/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.platform.Server;

public class ServerMetadata
extends Server {
    private String id;
    private String version;
    private String url;
    private Date startTime;

    public ServerMetadata(Configuration conf) {
        this.id = conf.getString("sonar.core.id");
        this.version = conf.getString("sonar.core.version");
        this.url = ServerMetadata.getURL(conf);
        String dateString = conf.getString("sonar.core.startTime");
        if (dateString != null) {
            try {
                this.startTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(dateString);
            }
            catch (ParseException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("The property sonar.core.startTime is badly formatted.", (Throwable)e);
            }
        }
    }

    public static String getURL(Configuration conf) {
        return StringUtils.removeEnd((String)conf.getString("sonar.host.url", "http://localhost:9000"), (String)"/");
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getStartedAt() {
        return this.startTime;
    }

    public String getURL() {
        return this.url;
    }
}

