/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.sonar.api.database.model.Snapshot;

public class PastSnapshot {
    private int index;
    private String mode;
    private String modeParameter;
    private Snapshot projectSnapshot;
    private Date targetDate;

    public PastSnapshot(String mode, Date targetDate, Snapshot projectSnapshot) {
        this.mode = mode;
        this.targetDate = targetDate;
        this.projectSnapshot = projectSnapshot;
    }

    public PastSnapshot(String mode, Snapshot projectSnapshot) {
        this.mode = mode;
        this.projectSnapshot = projectSnapshot;
    }

    public PastSnapshot setIndex(int index) {
        this.index = index;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public Snapshot getProjectSnapshot() {
        return this.projectSnapshot;
    }

    public Date getDate() {
        return this.projectSnapshot.getCreatedAt();
    }

    public String getMode() {
        return this.mode;
    }

    public String getModeParameter() {
        return this.modeParameter;
    }

    public PastSnapshot setModeParameter(String s) {
        this.modeParameter = s;
        return this;
    }

    public Integer getProjectSnapshotId() {
        return this.projectSnapshot != null ? this.projectSnapshot.getId() : null;
    }

    public Date getTargetDate() {
        return this.targetDate;
    }

    public PastSnapshot setTargetDate(Date d) {
        this.targetDate = d;
        return this;
    }

    public String toString() {
        if (StringUtils.equals((String)this.mode, (String)"version")) {
            return String.format("Compare to version " + this.modeParameter + "(" + this.getDate() + ")", new Object[0]);
        }
        if (StringUtils.equals((String)this.mode, (String)"days")) {
            return String.format("Compare over " + this.modeParameter + " days (" + this.getDate() + ")", new Object[0]);
        }
        if (StringUtils.equals((String)this.mode, (String)"previous_analysis")) {
            return String.format("Compare to previous analysis  (" + this.getDate() + ")", new Object[0]);
        }
        if (StringUtils.equals((String)this.mode, (String)"date")) {
            return String.format("Compare to date " + this.getDate(), new Object[0]);
        }
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

