/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.components.PastSnapshot;

public class PastSnapshotFinderByDate
implements BatchExtension {
    public static final String MODE = "date";
    private DatabaseSession session;

    public PastSnapshotFinderByDate(DatabaseSession session) {
        this.session = session;
    }

    PastSnapshot findByDate(Snapshot projectSnapshot, Date date) {
        String hql = "from " + Snapshot.class.getSimpleName() + " where createdAt>=:date AND resourceId=:resourceId AND status=:status AND qualifier<>:lib order by createdAt asc";
        List snapshots = this.session.createQuery(hql).setParameter(MODE, (Object)date).setParameter("resourceId", (Object)projectSnapshot.getResourceId()).setParameter("status", (Object)"P").setParameter("lib", (Object)"LIB").setMaxResults(1).getResultList();
        if (snapshots.isEmpty()) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return new PastSnapshot(MODE, date, (Snapshot)snapshots.get(0)).setModeParameter(format.format(date));
    }
}

