/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dao;

import java.util.List;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.jpa.dao.BaseDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilesDao
extends BaseDao {
    public ProfilesDao(DatabaseSession session) {
        super(session);
    }

    public List<RulesProfile> getActiveProfiles() {
        return this.getSession().getResults(RulesProfile.class, new Object[]{"defaultProfile", true});
    }

    public RulesProfile getActiveProfile(String languageKey, String projectResourceKey) {
        ResourceModel projectResource = (ResourceModel)this.getSession().getSingleResult(ResourceModel.class, new Object[]{"key", projectResourceKey, "scope", "PRJ"});
        if (projectResource != null && projectResource.getRulesProfile() != null) {
            return projectResource.getRulesProfile();
        }
        return (RulesProfile)this.getSession().getSingleResult(RulesProfile.class, new Object[]{"defaultProfile", true, "language", languageKey});
    }

    public List<RulesProfile> getProfiles(String languageKey) {
        return this.getSession().getResults(RulesProfile.class, new Object[]{"language", languageKey});
    }

    public List<RulesProfile> getProfiles() {
        return this.getSession().getResults(RulesProfile.class);
    }

    public List<RulesProfile> getProvidedProfiles() {
        return this.getSession().getResults(RulesProfile.class, new Object[]{"provided", true});
    }

    public RulesProfile getProfile(String languageKey, String profileName) {
        return (RulesProfile)this.getSession().getSingleResult(RulesProfile.class, new Object[]{"language", languageKey, "name", profileName});
    }

    public RulesProfile getProfileById(int profileId) {
        return (RulesProfile)this.getSession().getEntityManager().getReference(RulesProfile.class, (Object)profileId);
    }
}

