/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.checks.checkers;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.checks.checkers.CheckerFactory;
import org.sonar.api.checks.checkers.UnvalidCheckerException;
import org.sonar.api.checks.profiles.Check;
import org.sonar.api.checks.profiles.CheckProfile;
import org.sonar.check.AnnotationIntrospector;
import org.sonar.check.CheckProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AnnotationCheckerFactory<CHECKER>
extends CheckerFactory<CHECKER> {
    private CheckProfile profile;
    private String repositoryKey;
    private Collection<Class<CHECKER>> checkerClasses;

    public AnnotationCheckerFactory(CheckProfile profile, String repositoryKey, Collection<Class<CHECKER>> checkerClasses) {
        this.profile = profile;
        this.repositoryKey = repositoryKey;
        this.checkerClasses = checkerClasses;
    }

    @Override
    public Map<Check, CHECKER> create() {
        Map<String, Class<CHECKER>> classesByKey = this.getClassesByKey(this.checkerClasses);
        IdentityHashMap<Check, CHECKER> map = new IdentityHashMap<Check, CHECKER>();
        for (Check check : this.profile.getChecks(this.repositoryKey)) {
            CHECKER checker;
            Class<CHECKER> clazz = classesByKey.get(check.getTemplateKey());
            if (clazz == null || (checker = this.instantiate(check, clazz)) == null) continue;
            map.put(check, checker);
        }
        return map;
    }

    CHECKER instantiate(Check check, Class<CHECKER> clazz) {
        try {
            CHECKER checker = clazz.newInstance();
            this.configureFields(check, checker);
            return checker;
        }
        catch (UnvalidCheckerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnvalidCheckerException("The checker " + clazz.getCanonicalName() + " can not be created", e);
        }
    }

    private void configureFields(Check check, CHECKER checker) throws IllegalAccessException {
        for (Map.Entry<String, String> entry : check.getProperties().entrySet()) {
            Field field = this.getField(checker, entry.getKey());
            if (field == null) {
                throw new UnvalidCheckerException("The field " + entry.getKey() + " does not exist or is not annotated with @CheckProperty");
            }
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            this.configureField(checker, field, entry);
        }
    }

    private void configureField(Object checker, Field field, Map.Entry<String, String> parameter) throws IllegalAccessException {
        field.setAccessible(true);
        if (field.getType().equals(String.class)) {
            field.set(checker, parameter.getValue());
        } else if (field.getType().getSimpleName().equals("int")) {
            field.setInt(checker, Integer.parseInt(parameter.getValue()));
        } else if (field.getType().getSimpleName().equals("short")) {
            field.setShort(checker, Short.parseShort(parameter.getValue()));
        } else if (field.getType().getSimpleName().equals("long")) {
            field.setLong(checker, Long.parseLong(parameter.getValue()));
        } else if (field.getType().getSimpleName().equals("double")) {
            field.setDouble(checker, Double.parseDouble(parameter.getValue()));
        } else if (field.getType().getSimpleName().equals("boolean")) {
            field.setBoolean(checker, Boolean.parseBoolean(parameter.getValue()));
        } else if (field.getType().getSimpleName().equals("byte")) {
            field.setByte(checker, Byte.parseByte(parameter.getValue()));
        } else if (field.getType().equals(Integer.class)) {
            field.set(checker, new Integer(Integer.parseInt(parameter.getValue())));
        } else if (field.getType().equals(Long.class)) {
            field.set(checker, new Long(Long.parseLong(parameter.getValue())));
        } else if (field.getType().equals(Double.class)) {
            field.set(checker, new Double(Double.parseDouble(parameter.getValue())));
        } else if (field.getType().equals(Boolean.class)) {
            field.set(checker, Boolean.parseBoolean(parameter.getValue()));
        } else {
            throw new UnvalidCheckerException("The type of the field " + field + " is not supported: " + field.getType());
        }
    }

    private Field getField(Object checker, String key) {
        Field[] fields;
        for (Field field : fields = checker.getClass().getDeclaredFields()) {
            CheckProperty annotation = field.getAnnotation(CheckProperty.class);
            if (annotation == null || !key.equals(field.getName()) && !key.equals(annotation.key())) continue;
            return field;
        }
        return null;
    }

    private Map<String, Class<CHECKER>> getClassesByKey(Collection<Class<CHECKER>> checkerClasses) {
        HashMap<String, Class<CHECKER>> result = new HashMap<String, Class<CHECKER>>();
        for (Class<CHECKER> checkerClass : checkerClasses) {
            String key = AnnotationIntrospector.getCheckKey(checkerClass);
            if (key == null) continue;
            result.put(key, checkerClass);
        }
        return result;
    }
}

