/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.checks.profiles;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.sonar.api.checks.profiles.Check;
import org.sonar.api.checks.profiles.CheckProfile;
import org.sonar.check.Priority;

@Deprecated
public final class CheckProfileXmlMarshaller {
    public static void toXml(CheckProfile profile, Writer writer) {
        CheckProfileXmlMarshaller.getXStream().toXML((Object)profile, writer);
    }

    public static CheckProfile fromXml(Reader xml) {
        return (CheckProfile)CheckProfileXmlMarshaller.getXStream().fromXML(xml);
    }

    public static CheckProfile fromXmlInClasspath(String pathToXml) {
        return CheckProfileXmlMarshaller.fromXmlInClasspath(pathToXml, CheckProfileXmlMarshaller.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CheckProfile fromXmlInClasspath(String pathToXml, Class clazz) {
        InputStreamReader reader = new InputStreamReader(clazz.getResourceAsStream(pathToXml));
        try {
            CheckProfile checkProfile = CheckProfileXmlMarshaller.fromXml(reader);
            return checkProfile;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private static XStream getXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new CompactDriver());
        xstream.setClassLoader(CheckProfileXmlMarshaller.class.getClassLoader());
        xstream.registerConverter((Converter)new CheckConverter());
        xstream.alias("profile", CheckProfile.class);
        xstream.alias("check", Check.class);
        xstream.addImplicitCollection(CheckProfile.class, "checks");
        return xstream;
    }

    private static class CheckConverter
    implements Converter {
        private CheckConverter() {
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(Check.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            Check check = (Check)value;
            writer.startNode("repository");
            writer.setValue(check.getRepositoryKey());
            writer.endNode();
            writer.startNode("template");
            writer.setValue(check.getTemplateKey());
            writer.endNode();
            writer.startNode("priority");
            writer.setValue(check.getPriority().toString());
            writer.endNode();
            for (Map.Entry<String, String> entry : check.getProperties().entrySet()) {
                if (entry.getValue() == null) continue;
                writer.startNode("property");
                writer.startNode("key");
                writer.setValue(entry.getKey());
                writer.endNode();
                writer.startNode("value");
                writer.setValue(entry.getValue());
                writer.endNode();
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Check check = new Check();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                this.readValue(reader, check);
                reader.moveUp();
            }
            return check;
        }

        private void readValue(HierarchicalStreamReader reader, Check check) {
            if (reader.getNodeName().equals("repository")) {
                check.setRepositoryKey(reader.getValue());
            } else if (reader.getNodeName().equals("template")) {
                check.setTemplateKey(reader.getValue());
            } else if (reader.getNodeName().equals("priority")) {
                check.setPriority(Priority.valueOf((String)reader.getValue()));
            } else if (reader.getNodeName().equals("property")) {
                reader.moveDown();
                String key = reader.getValue();
                reader.moveUp();
                reader.moveDown();
                String value = reader.getValue();
                reader.moveUp();
                check.addProperty(key, value);
            }
        }
    }

    private static class XDataPrintWriter
    extends CompactWriter {
        public XDataPrintWriter(Writer writer) {
            super(writer, XML_1_0);
        }
    }

    private static class CompactDriver
    extends XppDriver {
        private CompactDriver() {
        }

        public HierarchicalStreamWriter createWriter(Writer out) {
            return new XDataPrintWriter(out);
        }
    }
}

