/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.GuardedException;
import org.netbeans.modules.editor.impl.SearchBar;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ReplaceBar
extends JPanel {
    private static ReplaceBar replacebarInstance = null;
    private static final Logger LOG = Logger.getLogger(ReplaceBar.class.getName());
    private static final boolean CLOSE_ON_ENTER = Boolean.getBoolean("org.netbeans.modules.editor.search.closeOnEnter");
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final int defaultIncremantalSearchComboWidth = 200;
    private static final int maxIncremantalSearchComboWidth = 350;
    private SearchBar searchBar;
    private final FocusAdapter focusAdapterForComponent;
    private final JComboBox replaceComboBox;
    private final JTextField replaceTextField;
    private boolean hadFocusOnReplaceTextField = false;
    private final JButton replaceButton;
    private final JButton replaceAllButton;
    private final JPanel padding;
    private final JLabel replaceLabel;
    private final JCheckBox preserveCaseCheckBox;
    private ActionListener actionListenerForPreserveCase;
    private final JCheckBox backwardsCheckBox;
    private final FocusTraversalPolicy searchBarFocusTraversalPolicy;
    private ArrayList<JComponent> focusList = new ArrayList();
    private final JButton expandButton;
    private final JPopupMenu expandPopup;
    private final List<Component> inBar = new ArrayList<Component>();
    private final LinkedList<Component> inPopup = new LinkedList();
    private final List<Component> barOrder = new ArrayList<Component>();
    private boolean isPopupGoingToShow = false;
    private boolean isPopupShown = false;
    private ActionListener closeButtonListener;

    public static ReplaceBar getInstance(SearchBar searchBar) {
        if (replacebarInstance == null) {
            replacebarInstance = new ReplaceBar(searchBar);
        }
        if (replacebarInstance.getSearchBar() != searchBar) {
            replacebarInstance.setSearchBar(searchBar);
        }
        return replacebarInstance;
    }

    private ReplaceBar(SearchBar searchBar) {
        this.setSearchBar(searchBar);
        this.focusAdapterForComponent = this.createFocusAdapterForComponent();
        this.addEscapeKeystrokeFocusBackTo(this);
        searchBar.addKeystrokeFindActionTo(this);
        searchBar.addKeystrokeReplaceActionTo(this);
        this.setLayout(new BoxLayout(this, 2));
        this.setFocusCycleRoot(true);
        Color bgColor = this.getBackground();
        this.setBackground(new Color(Math.max(0, bgColor.getRed() - 20), Math.max(0, bgColor.getGreen() - 20), Math.max(0, bgColor.getBlue() - 20)));
        this.setForeground(UIManager.getColor("textText"));
        this.add(Box.createHorizontalStrut(8));
        this.replaceComboBox = ReplaceBar.createReplaceComboBox();
        this.replaceLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.replaceLabel, (String)NbBundle.getMessage(ReplaceBar.class, (String)"CTL_Replace"));
        this.replaceLabel.setLabelFor(this.replaceComboBox);
        this.add(this.replaceLabel);
        this.replaceTextField = (JTextField)this.replaceComboBox.getEditor().getEditorComponent();
        this.replaceTextField.setToolTipText(NbBundle.getMessage(ReplaceBar.class, (String)"TOOLTIP_ReplaceText"));
        ActionMap origActionMap = this.replaceTextField.getActionMap();
        ActionMap newActionMap = new ActionMap();
        for (Object key : origActionMap.allKeys()) {
            newActionMap.put(key, origActionMap.get(key));
        }
        this.replaceTextField.setActionMap(newActionMap);
        this.replaceTextField.getActionMap().remove("toggle-componentOrientation");
        this.replaceTextField.getInputMap().put(KeyStroke.getKeyStroke(72, 128), "none");
        this.replaceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ReplaceBar.this.hadFocusOnReplaceTextField = true;
                ReplaceBar.this.getSearchBar().lostFocusOnTextField();
            }
        });
        this.addEnterKeystrokeReplaceTo(this.replaceTextField);
        this.addShiftEnterReplaceAllTo(this.replaceTextField);
        this.add(this.replaceComboBox);
        JToolBar.Separator leftSeparator = new JToolBar.Separator();
        leftSeparator.setOrientation(1);
        this.add(leftSeparator);
        this.replaceButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.replaceButton, (String)NbBundle.getMessage(ReplaceBar.class, (String)"CTL_ReplaceNext"));
        this.replaceButton.setMargin(BUTTON_INSETS);
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceBar.this.replace();
            }
        });
        this.add(this.replaceButton);
        this.replaceAllButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.replaceAllButton, (String)NbBundle.getMessage(ReplaceBar.class, (String)"CTL_ReplaceAll"));
        this.replaceAllButton.setMargin(BUTTON_INSETS);
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceBar.this.replaceAll();
            }
        });
        this.add(this.replaceAllButton);
        this.changeButtonsSizeAsSearchBarButtons();
        JToolBar.Separator rightSeparator = new JToolBar.Separator();
        rightSeparator.setOrientation(1);
        this.add(rightSeparator);
        this.backwardsCheckBox = searchBar.createCheckBox("CTL_BackwardsReplace", "find-backward-search");
        this.add(this.backwardsCheckBox);
        this.preserveCaseCheckBox = searchBar.createCheckBox("CTL_PreserveCase", "find-preserve-case");
        this.add(this.preserveCaseCheckBox);
        this.backwardsCheckBox.setSelected(searchBar.getFindSupportValue("find-backward-search"));
        this.preserveCaseCheckBox.setSelected(searchBar.getFindSupportValue("find-preserve-case"));
        this.preserveCaseCheckBox.setEnabled(!searchBar.getRegExp() && !searchBar.getFindSupportValue("find-match-case"));
        this.expandButton = this.createExpandButton();
        this.expandPopup = this.createExpandPopup(this.expandButton);
        this.add(this.expandButton);
        this.expandButton.setVisible(true);
        this.padding = new JPanel();
        this.padding.setOpaque(false);
        this.add(this.padding);
        this.searchBarFocusTraversalPolicy = this.createSearchBarFocusTraversalPolicy();
        this.setVisible(false);
        this.createFocusList();
        this.makeBarExpandable();
    }

    private SearchBar getSearchBar() {
        return this.searchBar;
    }

    private void setSearchBar(SearchBar searchBar) {
        this.searchBar = searchBar;
        searchBar.addActualComponentListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReplaceBar.this.getSearchBar().getActualTextComponent().addFocusListener(ReplaceBar.this.focusAdapterForComponent);
            }
        });
        this.createFocusList();
    }

    private void makeBarExpandable() {
        this.inBar.add(this.backwardsCheckBox);
        this.inBar.add(this.preserveCaseCheckBox);
        this.barOrder.addAll(Arrays.asList(this.getComponents()));
        this.remove(this.expandButton);
        this.expandButton.setVisible(false);
    }

    private void showExpandedMenu() {
        if (!this.inPopup.isEmpty() && !this.expandPopup.isVisible()) {
            this.isPopupGoingToShow = true;
            Insets ins = this.expandPopup.getInsets();
            this.expandPopup.show(this.expandButton, 0, -(this.backwardsCheckBox.getHeight() * this.inPopup.size() + ins.top + ins.bottom));
        }
    }

    private void hideExpandedMenu() {
        if (this.expandPopup.isVisible()) {
            this.expandPopup.setVisible(false);
            this.replaceTextField.requestFocusInWindow();
        }
    }

    private JButton createExpandButton() throws MissingResourceException {
        JButton expButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_expand.png", (boolean)false));
        expButton.setMnemonic(NbBundle.getMessage(SearchBar.class, (String)"CTL_ReplaceExpandButton_Mnemonic").charAt(0));
        expButton.setToolTipText(NbBundle.getMessage(ReplaceBar.class, (String)"TOOLTIP_ReplaceExpandButton"));
        expButton.setMargin(BUTTON_INSETS);
        expButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = !ReplaceBar.this.isPopupShown;
                ReplaceBar.this.isPopupShown = state;
                if (state) {
                    ReplaceBar.this.showExpandedMenu();
                } else {
                    ReplaceBar.this.hideExpandedMenu();
                }
            }
        });
        return expButton;
    }

    private JPopupMenu createExpandPopup(final JButton expButton) {
        JPopupMenu expPopup = new JPopupMenu();
        expPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (expButton.getMousePosition() == null) {
                    expButton.setContentAreaFilled(false);
                    expButton.setBorderPainted(false);
                    ReplaceBar.this.isPopupShown = false;
                }
            }
        });
        return expPopup;
    }

    @Override
    public Dimension getPreferredSize() {
        this.computeLayout();
        return super.getPreferredSize();
    }

    private void computeLayout() {
        int parentWidth = this.getParent().getWidth();
        int totalWidth = 0;
        for (Component c : this.getComponents()) {
            if (c == this.padding) continue;
            totalWidth += c.getPreferredSize().width;
        }
        boolean change = false;
        if (totalWidth <= parentWidth) {
            while (!this.inPopup.isEmpty()) {
                Component c = this.inPopup.getFirst();
                if ((totalWidth += c.getPreferredSize().width) <= parentWidth) {
                    this.inPopup.removeFirst();
                    this.inBar.add(c);
                    this.expandPopup.remove(c);
                    this.add(c, this.barOrder.indexOf(c));
                    change = true;
                    continue;
                }
                break;
            }
        } else {
            while (totalWidth > parentWidth && !this.inBar.isEmpty()) {
                Component c = this.inBar.remove(this.inBar.size() - 1);
                this.inPopup.addFirst(c);
                this.remove(c);
                this.expandPopup.add(c, 0);
                totalWidth -= c.getPreferredSize().width;
                change = true;
            }
        }
        if (change) {
            if (this.inPopup.isEmpty()) {
                this.remove(this.expandButton);
                this.expandButton.setVisible(false);
            } else if (this.getComponentIndex(this.expandButton) < 0) {
                this.add((Component)this.expandButton, this.getComponentIndex(this.padding));
                this.expandButton.setVisible(true);
            }
            this.revalidate();
            this.expandPopup.invalidate();
            this.expandPopup.validate();
        }
    }

    private int getComponentIndex(Component c) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (c != comps[i]) continue;
            return i;
        }
        return -1;
    }

    private void changeButtonsSizeAsSearchBarButtons() {
        int diffEven;
        int searchBarButtonsSize = this.searchBar.getFindNextButton().getPreferredSize().width + this.searchBar.getFindPreviousButton().getPreferredSize().width;
        int replaceBarButtonsSize = this.replaceButton.getPreferredSize().width + this.replaceAllButton.getPreferredSize().width;
        int diffButtonsSize = (searchBarButtonsSize - replaceBarButtonsSize) / 2;
        int n = diffEven = diffButtonsSize % 2 == 0 ? 0 : 1;
        if (diffButtonsSize > 0) {
            this.replaceButton.setPreferredSize(new Dimension(this.replaceButton.getPreferredSize().width + diffButtonsSize + diffEven, this.replaceButton.getPreferredSize().height));
            this.replaceAllButton.setPreferredSize(new Dimension(this.replaceAllButton.getPreferredSize().width + diffButtonsSize, this.replaceAllButton.getPreferredSize().height));
        } else {
            this.searchBar.getFindNextButton().setPreferredSize(new Dimension(this.searchBar.getFindNextButton().getPreferredSize().width - diffButtonsSize + diffEven, this.searchBar.getFindNextButton().getPreferredSize().height));
            this.searchBar.getFindPreviousButton().setPreferredSize(new Dimension(this.searchBar.getFindPreviousButton().getPreferredSize().width - diffButtonsSize, this.searchBar.getFindPreviousButton().getPreferredSize().height));
        }
    }

    private void addEnterKeystrokeReplaceTo(JTextField replaceTextField) {
        replaceTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "replace-next");
        replaceTextField.getActionMap().put("replace-next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceBar.this.replace();
                if (CLOSE_ON_ENTER) {
                    ReplaceBar.this.looseFocus();
                }
            }
        });
    }

    private void addShiftEnterReplaceAllTo(JTextField textField) {
        textField.getInputMap().put(KeyStroke.getKeyStroke(10, 1, true), "replace-all");
        textField.getActionMap().put("replace-all", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceBar.this.replaceAll();
                if (CLOSE_ON_ENTER) {
                    ReplaceBar.this.looseFocus();
                }
            }
        });
    }

    private void createFocusList() {
        this.focusList.clear();
        this.focusList.add(this.searchBar.getIncSearchTextField());
        this.focusList.add(this.replaceTextField);
        this.focusList.add(this.replaceButton);
        this.focusList.add(this.replaceAllButton);
        this.focusList.add(this.expandButton);
        this.focusList.add(this.searchBar.getFindPreviousButton());
        this.focusList.add(this.searchBar.getFindNextButton());
        this.focusList.add(this.searchBar.getExpandButton());
    }

    private ArrayList<JComponent> getFocusList() {
        return this.focusList;
    }

    private FocusTraversalPolicy createSearchBarFocusTraversalPolicy() {
        return new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                int indexOf = ReplaceBar.this.getFocusList().indexOf(aComponent);
                if (indexOf == -1) {
                    return null;
                }
                if (indexOf == ReplaceBar.this.getFocusList().size() - 1) {
                    return this.isFocusableComponent((Component)ReplaceBar.this.getFocusList().get(0)) ? (Component)ReplaceBar.this.getFocusList().get(0) : this.getComponentAfter(aContainer, (Component)ReplaceBar.this.getFocusList().get(0));
                }
                return this.isFocusableComponent((Component)ReplaceBar.this.getFocusList().get(indexOf + 1)) ? (Component)ReplaceBar.this.getFocusList().get(indexOf + 1) : this.getComponentAfter(aContainer, (Component)ReplaceBar.this.getFocusList().get(indexOf + 1));
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                int indexOf = ReplaceBar.this.getFocusList().indexOf(aComponent);
                if (indexOf == -1) {
                    return null;
                }
                if (indexOf == 0) {
                    return this.isFocusableComponent((Component)ReplaceBar.this.getFocusList().get(ReplaceBar.this.getFocusList().size() - 1)) && ((JComponent)ReplaceBar.this.getFocusList().get(ReplaceBar.this.getFocusList().size() - 1)).isVisible() ? (Component)ReplaceBar.this.getFocusList().get(ReplaceBar.this.getFocusList().size() - 1) : this.getComponentBefore(aContainer, (Component)ReplaceBar.this.getFocusList().get(ReplaceBar.this.getFocusList().size() - 1));
                }
                return this.isFocusableComponent((Component)ReplaceBar.this.getFocusList().get(indexOf - 1)) ? (Component)ReplaceBar.this.getFocusList().get(indexOf - 1) : this.getComponentBefore(aContainer, (Component)ReplaceBar.this.getFocusList().get(indexOf - 1));
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return (Component)ReplaceBar.this.getFocusList().get(0);
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return (Component)ReplaceBar.this.getFocusList().get(ReplaceBar.this.getFocusList().size() - 1);
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return (Component)ReplaceBar.this.getFocusList().get(0);
            }

            private boolean isFocusableComponent(Component aComponent) {
                return aComponent.isEnabled() && aComponent.isVisible();
            }
        };
    }

    private FocusAdapter createFocusAdapterForComponent() {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ReplaceBar.this.hadFocusOnReplaceTextField = false;
            }
        };
    }

    private static JComboBox createReplaceComboBox() {
        JComboBox incSearchComboBox = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                int editsize = this.getEditor().getEditorComponent().getPreferredSize().width + 10;
                int width = editsize > 200 && editsize < 350 ? editsize : (editsize >= 350 ? 350 : 200);
                return new Dimension(width, super.getPreferredSize().height);
            }
        };
        incSearchComboBox.setEditable(true);
        return incSearchComboBox;
    }

    private void addEscapeKeystrokeFocusBackTo(JPanel jpanel) {
        jpanel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "loose-focus");
        jpanel.getActionMap().put("loose-focus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceBar.this.looseFocus();
            }
        });
    }

    void updateReplaceComboBoxHistory(String incrementalSearchText) {
        for (int i = this.replaceComboBox.getItemCount() - 1; i >= 0; --i) {
            String item = (String)this.replaceComboBox.getItemAt(i);
            if (!item.equals(incrementalSearchText)) continue;
            this.replaceComboBox.removeItemAt(i);
        }
        ((MutableComboBoxModel)this.replaceComboBox.getModel()).insertElementAt(incrementalSearchText, 0);
        this.replaceComboBox.setSelectedIndex(0);
    }

    private ActionListener getActionListenerForPreserveCase() {
        if (this.actionListenerForPreserveCase == null) {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReplaceBar.this.preserveCaseCheckBox.setEnabled(!ReplaceBar.this.searchBar.getRegexpCheckBox().isSelected() && !ReplaceBar.this.searchBar.getMatchCaseCheckBox().isSelected());
                }
            };
        }
        return this.actionListenerForPreserveCase;
    }

    private ActionListener getCloseButtonListener() {
        if (this.closeButtonListener == null) {
            this.closeButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReplaceBar.this.looseFocus();
                }
            };
        }
        return this.closeButtonListener;
    }

    private void unchangeSearchBarToBeOnlySearchBar() throws MissingResourceException {
        this.searchBar.getCloseButton().removeActionListener(this.getCloseButtonListener());
        Mnemonics.setLocalizedText((JLabel)this.searchBar.getFindLabel(), (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Find"));
        Dimension oldDimensionForFindLabel = this.searchBar.getFindLabel().getUI().getMinimumSize(this.searchBar.getFindLabel());
        this.searchBar.getFindLabel().setMinimumSize(oldDimensionForFindLabel);
        this.searchBar.getFindLabel().setPreferredSize(oldDimensionForFindLabel);
        this.searchBar.addEscapeKeystrokeFocusBackTo(this.searchBar);
        if (this.searchBar.getActualTextComponent() != null) {
            this.searchBar.getActualTextComponent().removeFocusListener(this.focusAdapterForComponent);
        }
        this.searchBar.getRegexpCheckBox().removeActionListener(this.getActionListenerForPreserveCase());
        this.searchBar.getMatchCaseCheckBox().removeActionListener(this.getActionListenerForPreserveCase());
        this.searchBar.setFocusTraversalPolicy(null);
        this.searchBar.looseFocus();
    }

    private void changeSearchBarToBePartOfReplaceBar() throws MissingResourceException {
        this.searchBar.getCloseButton().addActionListener(this.getCloseButtonListener());
        Mnemonics.setLocalizedText((JLabel)this.searchBar.getFindLabel(), (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Replace_Find"));
        Dimension newDimensionForFindLabel = new Dimension(this.replaceLabel.getPreferredSize().width, this.searchBar.getFindLabel().getPreferredSize().height);
        this.searchBar.getFindLabel().setMinimumSize(newDimensionForFindLabel);
        this.searchBar.getFindLabel().setPreferredSize(newDimensionForFindLabel);
        this.addEscapeKeystrokeFocusBackTo(this.searchBar);
        if (this.searchBar.getActualTextComponent() != null) {
            this.searchBar.getActualTextComponent().addFocusListener(this.focusAdapterForComponent);
        }
        this.searchBar.getRegexpCheckBox().addActionListener(this.getActionListenerForPreserveCase());
        this.searchBar.getMatchCaseCheckBox().addActionListener(this.getActionListenerForPreserveCase());
        this.searchBar.setFocusTraversalPolicy(this.searchBarFocusTraversalPolicy);
        this.setFocusTraversalPolicy(this.searchBarFocusTraversalPolicy);
        this.searchBar.computeLayout();
    }

    void looseFocus() {
        this.hadFocusOnReplaceTextField = false;
        if (!this.isVisible()) {
            return;
        }
        if (this.isPopupGoingToShow) {
            this.isPopupGoingToShow = false;
            return;
        }
        this.unchangeSearchBarToBeOnlySearchBar();
        this.setVisible(false);
    }

    void gainFocus() {
        if (!this.isVisible()) {
            this.changeSearchBarToBePartOfReplaceBar();
            this.setVisible(true);
        }
        this.searchBar.gainFocus();
        if (this.searchBar.getIncSearchTextField().getText().isEmpty()) {
            this.searchBar.getIncSearchTextField().requestFocusInWindow();
        } else {
            this.replaceTextField.requestFocusInWindow();
        }
    }

    boolean hadFocusOnTextField() {
        return this.hadFocusOnReplaceTextField;
    }

    void lostFocusOnTextField() {
        this.hadFocusOnReplaceTextField = false;
    }

    private void replace() {
        this.replace(false);
    }

    private void replaceAll() {
        this.replace(true);
    }

    private void replace(boolean replaceAll) {
        this.searchBar.updateIncSearchComboBoxHistory(this.searchBar.getIncSearchTextField().getText());
        this.updateReplaceComboBoxHistory(this.replaceTextField.getText());
        EditorFindSupport findSupport = EditorFindSupport.getInstance();
        HashMap<String, Object> findProps = new HashMap<String, Object>();
        findProps.putAll(this.searchBar.getFindProps());
        findProps.put("find-replace-with", this.replaceTextField.getText());
        findProps.put("find-backward-search", this.backwardsCheckBox.isSelected());
        findProps.put("find-preserve-case", this.preserveCaseCheckBox.isSelected() && this.preserveCaseCheckBox.isEnabled());
        findSupport.putFindProperties(findProps);
        if (replaceAll) {
            findSupport.replaceAll(findProps);
        } else {
            try {
                findSupport.replace(findProps, false);
                findSupport.find(findProps, false);
            }
            catch (GuardedException ge) {
                LOG.log(Level.FINE, null, ge);
                Toolkit.getDefaultToolkit().beep();
            }
            catch (BadLocationException ble) {
                LOG.log(Level.WARNING, null, ble);
            }
        }
    }
}

