/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

class AssignComments
extends TreeScanner<Void, Void> {
    private final CompilationInfo info;
    private final CompilationUnitTree unit;
    private final Tree commentMapTarget;
    private final boolean resolveImports;
    private final TokenSequence<JavaTokenId> seq;
    private final CommentHandlerService commentService;
    private final SourcePositions positions;
    private int tokenIndexAlreadyAdded = -1;
    private boolean mapComments;
    private static Logger log = Logger.getLogger(AssignComments.class.getName());

    public AssignComments(CompilationInfo info, Tree commentMapTarget, boolean resolveImports, TokenSequence<JavaTokenId> seq) {
        this(info, commentMapTarget, resolveImports, seq, info.getCompilationUnit());
    }

    public AssignComments(CompilationInfo info, Tree commentMapTarget, boolean resolveImports, TokenSequence<JavaTokenId> seq, CompilationUnitTree cut) {
        this(info, commentMapTarget, resolveImports, seq, cut, info.getTrees().getSourcePositions());
    }

    public AssignComments(CompilationInfo info, Tree commentMapTarget, boolean resolveImports, TokenSequence<JavaTokenId> seq, SourcePositions positions) {
        this(info, commentMapTarget, resolveImports, seq, info.getCompilationUnit(), positions);
    }

    private AssignComments(CompilationInfo info, Tree commentMapTarget, boolean resolveImports, TokenSequence<JavaTokenId> seq, CompilationUnitTree cut, SourcePositions positions) {
        this.info = info;
        this.unit = cut;
        this.seq = seq;
        this.commentMapTarget = commentMapTarget;
        this.resolveImports = resolveImports;
        this.commentService = CommentHandlerService.instance(info.impl.getJavacTask().getContext());
        this.positions = positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void scan(Tree tree, Void p) {
        if (tree == null) {
            return null;
        }
        boolean oldMapComments = this.mapComments;
        try {
            this.mapComments |= tree == this.commentMapTarget;
            if (this.commentMapTarget != null && this.info.getTreeUtilities().isSynthetic(new TreePath(new TreePath(this.info.getCompilationUnit()), tree))) {
                Void void_ = null;
                return void_;
            }
            if (this.commentMapTarget != null) {
                this.mapComments2(tree, true);
            }
            super.scan(tree, p);
            if (this.commentMapTarget != null) {
                this.mapComments2(tree, false);
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this.mapComments = oldMapComments;
        }
    }

    private void mapComments2(Tree tree, boolean preceding) {
        if (((JCTree)tree).pos <= 0) {
            return;
        }
        this.collect(tree, preceding);
    }

    private void collect(Tree tree, boolean preceding) {
        if (this.isEvil(tree)) {
            return;
        }
        if (preceding) {
            BlockTree blockTree;
            int pos = this.findInterestingStart((JCTree)tree);
            this.seq.move(pos);
            this.lookForPreceedings(this.seq, tree);
            if (tree instanceof BlockTree && (blockTree = (BlockTree)tree).getStatements().isEmpty()) {
                this.lookWithinEmptyBlock(this.seq, blockTree);
            }
        } else {
            this.lookForInline(this.seq, tree);
            this.lookForTrailing(this.seq, tree);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "T: " + tree + "\nC: " + this.commentService.getComments(tree));
        }
    }

    private void lookForInline(TokenSequence<JavaTokenId> seq, Tree tree) {
        seq.move((int)this.positions.getEndPosition(this.unit, tree));
        CommentsCollection result = new CommentsCollection();
        while (seq.moveNext()) {
            if (seq.token().id() == JavaTokenId.WHITESPACE) {
                if (this.numberOfNL((Token<JavaTokenId>)seq.token()) <= 0) continue;
                break;
            }
            if (!this.isComment((JavaTokenId)seq.token().id())) break;
            if (seq.index() > this.tokenIndexAlreadyAdded) {
                result.add((Token<JavaTokenId>)seq.token());
            }
            this.tokenIndexAlreadyAdded = seq.index();
            if (seq.token().id() != JavaTokenId.LINE_COMMENT) continue;
        }
        if (!result.isEmpty()) {
            CommentSet.RelativePosition position = CommentSet.RelativePosition.INLINE;
            this.attachComments(tree, result, position);
        }
    }

    private void attachComments(Tree tree, CommentsCollection result, CommentSet.RelativePosition position) {
        if (!this.mapComments) {
            return;
        }
        CommentSetImpl cs = this.commentService.getComments(tree);
        for (Token<JavaTokenId> token : result) {
            this.attachComment(position, cs, token);
        }
    }

    private boolean isEvil(Tree tree) {
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case MODIFIERS: 
            case COMPILATION_UNIT: 
            case PRIMITIVE_TYPE: {
                return true;
            }
        }
        return false;
    }

    private void lookForTrailing(TokenSequence<JavaTokenId> seq, Tree tree) {
        seq.move((int)this.positions.getEndPosition(this.unit, tree));
        LinkedList<TrailingCommentsDataHolder> comments = new LinkedList<TrailingCommentsDataHolder>();
        int maxLines = 0;
        int newlines = 0;
        int lastIndex = -1;
        while (seq.moveNext()) {
            Token t;
            if (lastIndex == -1) {
                lastIndex = seq.index();
            }
            if ((t = seq.token()).id() == JavaTokenId.WHITESPACE) {
                newlines += this.numberOfNL((Token<JavaTokenId>)t);
                continue;
            }
            if (this.isComment((JavaTokenId)t.id())) {
                if (seq.index() > this.tokenIndexAlreadyAdded) {
                    comments.add(new TrailingCommentsDataHolder(newlines, (Token<JavaTokenId>)t, lastIndex));
                }
                maxLines = Math.max(maxLines, newlines);
                newlines = t.id() == JavaTokenId.LINE_COMMENT ? 1 : 0;
                lastIndex = -1;
                continue;
            }
            if (t.id() != JavaTokenId.RBRACE) break;
            maxLines = Integer.MAX_VALUE;
            break;
        }
        int index = seq.index() - 1;
        maxLines = Math.max(maxLines, newlines);
        for (TrailingCommentsDataHolder h : comments) {
            if (h.newlines < maxLines) {
                this.attachComments(Collections.singleton(h.comment), tree, this.commentService, CommentSet.RelativePosition.TRAILING);
                continue;
            }
            index = h.index - 1;
            break;
        }
        this.tokenIndexAlreadyAdded = index;
    }

    private void lookWithinEmptyBlock(TokenSequence<JavaTokenId> seq, BlockTree tree) {
        if (this.moveTo(seq, JavaTokenId.LBRACE, true)) {
            if (seq.moveNext()) {
                CommentsCollection cc = this.getCommentsCollection(seq, Integer.MAX_VALUE);
                this.attachComments(tree, cc, CommentSet.RelativePosition.INNER);
            }
        } else {
            int end = (int)this.positions.getEndPosition(this.unit, tree);
            seq.move(end);
            seq.moveNext();
        }
    }

    private boolean moveTo(TokenSequence<JavaTokenId> seq, JavaTokenId toToken, boolean forward) {
        do {
            if (toToken != seq.token().id()) continue;
            return true;
        } while (!forward ? seq.movePrevious() : seq.moveNext());
        return false;
    }

    private void lookForPreceedings(TokenSequence<JavaTokenId> seq, Tree tree) {
        int reset = ((JCTree)tree).pos;
        CommentsCollection cc = null;
        while (seq.moveNext() && seq.offset() < reset) {
            JavaTokenId id = (JavaTokenId)seq.token().id();
            if (!this.isComment(id)) continue;
            if (cc == null) {
                cc = this.getCommentsCollection(seq, Integer.MAX_VALUE);
                continue;
            }
            cc.merge(this.getCommentsCollection(seq, Integer.MAX_VALUE));
        }
        this.attachComments(cc, tree, this.commentService, CommentSet.RelativePosition.PRECEDING);
        seq.move(reset);
        seq.moveNext();
        this.tokenIndexAlreadyAdded = seq.index();
    }

    private int findInterestingStart(JCTree tree) {
        int pos = (int)this.positions.getStartPosition(this.unit, tree);
        if (pos <= 0) {
            return 0;
        }
        this.seq.move(pos);
        block4: while (this.seq.movePrevious() && this.tokenIndexAlreadyAdded < this.seq.index()) {
            switch ((JavaTokenId)this.seq.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case JAVADOC_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block4;
                }
                case LBRACE: {
                    return this.seq.offset() + this.seq.token().length();
                }
            }
            return this.seq.offset() + this.seq.token().length();
        }
        return this.seq.offset() + (this.tokenIndexAlreadyAdded >= this.seq.index() ? this.seq.token().length() : 0);
    }

    private void consumeWS(TokenSequence<JavaTokenId> seq, boolean forward) {
        block3: while (forward ? seq.moveNext() : seq.movePrevious()) {
            switch ((JavaTokenId)seq.token().id()) {
                case WHITESPACE: {
                    continue block3;
                }
            }
            return;
        }
    }

    private int adjustByComments(int pos, CommentSetImpl comments) {
        List<Comment> cl = comments.getComments(CommentSet.RelativePosition.INLINE);
        if (!cl.isEmpty()) {
            for (Comment comment : cl) {
                pos = Math.max(pos, comment.endPos());
            }
        }
        if (!(cl = comments.getComments(CommentSet.RelativePosition.TRAILING)).isEmpty()) {
            for (Comment comment : cl) {
                pos = Math.max(pos, comment.endPos());
            }
        }
        return pos;
    }

    private void skipEvil(TokenSequence<JavaTokenId> ts) {
        do {
            JavaTokenId id = (JavaTokenId)ts.token().id();
            switch (id) {
                case WHITESPACE: 
                case PUBLIC: 
                case PRIVATE: 
                case PROTECTED: 
                case ABSTRACT: 
                case FINAL: 
                case STATIC: 
                case VOID: 
                case VOLATILE: 
                case NATIVE: 
                case STRICTFP: 
                case INT: 
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case CONST: 
                case LONG: {
                    break;
                }
                default: {
                    return;
                }
            }
        } while (ts.moveNext());
    }

    private double belongsTo(int startPos, int endPos, TokenSequence<JavaTokenId> ts) {
        int index = ts.index();
        double result = this.getForwardWeight(endPos, ts) - this.getBackwardWeight(startPos, ts);
        ts.moveIndex(index);
        ts.moveNext();
        return result;
    }

    private double getForwardWeight(int endPos, TokenSequence<JavaTokenId> ts) {
        double result = 0.0;
        ts.move(endPos);
        while (ts.moveNext()) {
            if (ts.token().id() == JavaTokenId.WHITESPACE) {
                int nls = this.numberOfNL((Token<JavaTokenId>)ts.token());
                result = nls == 0 ? 1.0 : (double)(1 / nls);
                continue;
            }
            if (!this.isComment((JavaTokenId)ts.token().id())) break;
            if (ts.token().id() == JavaTokenId.LINE_COMMENT) {
                return 1.0;
            }
            result = 0.0;
            break;
        }
        return result;
    }

    private double getBackwardWeight(int startPos, TokenSequence<JavaTokenId> ts) {
        double result = 0.0;
        ts.move(startPos);
        while (ts.movePrevious()) {
            if (ts.token().id() == JavaTokenId.WHITESPACE) {
                int nls = this.numberOfNL((Token<JavaTokenId>)ts.token());
                result = nls == 0 ? 0.0 : (double)(1 / nls);
                continue;
            }
            if (!this.isComment((JavaTokenId)ts.token().id())) break;
            result = 0.0;
            break;
        }
        return result;
    }

    private void attachComments(Iterable<? extends Token<JavaTokenId>> foundComments, Tree tree, CommentHandler ch, CommentSet.RelativePosition positioning) {
        if (foundComments == null || !foundComments.iterator().hasNext() || !this.mapComments) {
            return;
        }
        CommentSet set = this.createCommentSet(ch, tree);
        for (Token<JavaTokenId> token : foundComments) {
            this.attachComment(positioning, set, token);
        }
    }

    private void attachComment(CommentSet.RelativePosition positioning, CommentSet set, Token<JavaTokenId> comment) {
        Comment c = Comment.create(this.getStyle((JavaTokenId)comment.id()), comment.offset(null), this.getEndPos(comment), -2, this.getText(comment));
        set.addComment(positioning, c);
    }

    private String getText(Token<JavaTokenId> comment) {
        return String.valueOf(comment.text());
    }

    private int getEndPos(Token<JavaTokenId> comment) {
        return comment.offset(null) + comment.length();
    }

    private Comment.Style getStyle(JavaTokenId id) {
        switch (id) {
            case JAVADOC_COMMENT: {
                return Comment.Style.JAVADOC;
            }
            case LINE_COMMENT: {
                return Comment.Style.LINE;
            }
            case BLOCK_COMMENT: {
                return Comment.Style.BLOCK;
            }
        }
        return Comment.Style.WHITESPACE;
    }

    private int[] getBounds(JCTree tree) {
        return new int[]{(int)this.positions.getStartPosition(this.unit, tree), (int)this.positions.getEndPosition(this.unit, tree)};
    }

    private Tree getTree(TreeUtilities tu, TokenSequence<JavaTokenId> ts) {
        TreePath path;
        int start = ts.offset();
        if (ts.token().length() > 0) {
            ++start;
        }
        if ((path = tu.pathFor(start)) != null) {
            return path.getLeaf();
        }
        return null;
    }

    private int numberOfNL(Token<JavaTokenId> t) {
        int count = 0;
        CharSequence charSequence = t.text();
        for (int i = 0; i < charSequence.length(); ++i) {
            char a = charSequence.charAt(i);
            if ('\n' != a) continue;
            ++count;
        }
        return count;
    }

    private CommentsCollection getCommentsCollection(TokenSequence<JavaTokenId> ts, int maxTension) {
        CommentsCollection result = new CommentsCollection();
        Token t = ts.token();
        result.add((Token<JavaTokenId>)t);
        boolean isLC = t.id() == JavaTokenId.LINE_COMMENT;
        int lastCommentIndex = ts.index();
        int start = ts.offset();
        int end = ts.offset() + ts.token().length();
        while (ts.moveNext()) {
            if (ts.index() < this.tokenIndexAlreadyAdded) continue;
            t = ts.token();
            if (this.isComment((JavaTokenId)t.id())) {
                result.add((Token<JavaTokenId>)t);
                start = Math.min(ts.offset(), start);
                end = Math.max(ts.offset() + t.length(), end);
                isLC = t.id() == JavaTokenId.LINE_COMMENT;
                lastCommentIndex = ts.index();
                continue;
            }
            if (t.id() == JavaTokenId.WHITESPACE && this.numberOfNL((Token<JavaTokenId>)t) + (isLC ? 1 : 0) <= maxTension) continue;
        }
        ts.moveIndex(lastCommentIndex);
        ts.moveNext();
        this.tokenIndexAlreadyAdded = ts.index();
        result.setBounds(new int[]{start, end});
        return result;
    }

    private CommentSet createCommentSet(CommentHandler ch, Tree lastTree) {
        return ch.getComments(lastTree);
    }

    private boolean isComment(JavaTokenId tid) {
        switch (tid) {
            case LINE_COMMENT: 
            case JAVADOC_COMMENT: 
            case BLOCK_COMMENT: {
                return true;
            }
        }
        return false;
    }

    private static class CommentsCollection
    implements Iterable<Token<JavaTokenId>> {
        private final int[] bounds = new int[]{-2, -2};
        private final List<Token<JavaTokenId>> comments = new LinkedList<Token<JavaTokenId>>();

        private CommentsCollection() {
        }

        void add(Token<JavaTokenId> comment) {
            this.comments.add(comment);
        }

        boolean isEmpty() {
            return this.comments.isEmpty();
        }

        @Override
        public Iterator<Token<JavaTokenId>> iterator() {
            return this.comments.iterator();
        }

        void setBounds(int[] bounds) {
            this.bounds[0] = bounds[0];
            this.bounds[1] = bounds[1];
        }

        public int[] getBounds() {
            return (int[])this.bounds.clone();
        }

        public void merge(CommentsCollection cc) {
            this.comments.addAll(cc.comments);
            this.bounds[0] = Math.min(this.bounds[0], cc.bounds[0]);
            this.bounds[1] = Math.max(this.bounds[1], cc.bounds[1]);
        }
    }

    private static final class TrailingCommentsDataHolder {
        private final int newlines;
        private final Token<JavaTokenId> comment;
        private final int index;

        public TrailingCommentsDataHolder(int newlines, Token<JavaTokenId> comment, int index) {
            this.newlines = newlines;
            this.comment = comment;
            this.index = index;
        }
    }
}

