/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import hidden.org.codehaus.plexus.util.cli.CommandLineUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.apache.maven.artifact.UnknownRepositoryLayoutException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ConfigurationValidationResult;
import org.apache.maven.embedder.ContainerCustomizer;
import org.apache.maven.embedder.DefaultConfiguration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.plan.BuildPlanner;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.build.model.DefaultModelLineage;
import org.apache.maven.project.build.model.ModelLineage;
import org.apache.maven.project.build.model.ModelLineageBuilder;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostsProvider;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.netbeans.modules.maven.embedder.NbArtifactFactory;
import org.netbeans.modules.maven.embedder.NbArtifactResolver;
import org.netbeans.modules.maven.embedder.NbExtensionManager;
import org.netbeans.modules.maven.embedder.NbMavenWorkspaceStore;
import org.netbeans.modules.maven.embedder.NbWagonManager;
import org.netbeans.modules.maven.embedder.NullEmbedderLogger;
import org.netbeans.modules.maven.embedder.exec.MyLifecycleExecutor;
import org.netbeans.modules.maven.embedder.exec.NBBuildPlanner;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class EmbedderFactory {
    private static ThreadLocal<MavenEmbedder> projectTL = new ThreadLocal();
    private static boolean wasReset = true;
    private static MavenEmbedder project;
    private static MavenEmbedder online;
    private static SettingsFileListener fileListener;
    private static Logger LOG;

    private EmbedderFactory() {
    }

    public static synchronized void resetProjectEmbedder() {
        project = null;
        wasReset = true;
    }

    private static void setLocalRepoPreference(Configuration req) {
        Preferences prefs = NbPreferences.root().node("org/netbeans/modules/maven");
        String localRepo = prefs.get("localRepository", null);
        if (localRepo != null) {
            File file = new File(localRepo);
            if (file.exists() && file.isDirectory()) {
                req.setLocalRepository(file);
            } else if (!file.exists()) {
                file.mkdirs();
                req.setLocalRepository(file);
            }
        }
    }

    private static Properties copySystemProperties() {
        Properties props = new Properties();
        Enumeration<Object> keys = System.getProperties().keys();
        while (keys.hasMoreElements()) {
            Object o = keys.nextElement();
            props.put(o, System.getProperties().get(o));
        }
        return props;
    }

    public static MavenEmbedder createProjectLikeEmbedder() {
        DefaultConfiguration req = new DefaultConfiguration();
        req.setClassLoader(EmbedderFactory.class.getClassLoader());
        EmbedderFactory.setLocalRepoPreference((Configuration)req);
        req.addActiveProfile("netbeans-public").addActiveProfile("netbeans-private");
        Properties props = EmbedderFactory.copySystemProperties();
        req.setSystemProperties(EmbedderFactory.fillEnvVars(props));
        File userSettingsPath = MavenEmbedder.DEFAULT_USER_SETTINGS_FILE;
        File globalSettingsPath = InstalledFileLocator.getDefault().locate("maven2/settings.xml", null, false);
        ConfigurationValidationResult cvr = MavenEmbedder.validateConfiguration((Configuration)req);
        Exception userSettingsException = cvr.getUserSettingsException();
        if (userSettingsException != null) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)userSettingsException, (String)"Maven Settings file cannot be properly parsed. Until it's fixed, it will be ignored."));
        }
        if (cvr.isValid()) {
            req.setUserSettingsFile(userSettingsPath);
        } else {
            LOG.info("Maven settings file is corrupted. See http://www.netbeans.org/issues/show_bug.cgi?id=96919");
            req.setUserSettingsFile(globalSettingsPath);
        }
        req.setGlobalSettingsFile(globalSettingsPath);
        req.setMavenEmbedderLogger((MavenEmbedderLogger)new NullEmbedderLogger());
        req.setConfigurationCustomizer(new ContainerCustomizer(){

            public void customize(PlexusContainer plexusContainer) {
                ComponentDescriptor desc = plexusContainer.getComponentDescriptor(ArtifactFactory.ROLE);
                desc.setImplementation(NbArtifactFactory.class.getName());
                desc = plexusContainer.getComponentDescriptor("org.apache.maven.extension.ExtensionManager");
                desc.setImplementation(NbExtensionManager.class.getName());
                desc = plexusContainer.getComponentDescriptor("org.apache.maven.workspace.MavenWorkspaceStore");
                desc.setImplementation(NbMavenWorkspaceStore.class.getName());
                desc = plexusContainer.getComponentDescriptor(ArtifactResolver.ROLE);
                desc.setImplementation(NbArtifactResolver.class.getName());
                desc = plexusContainer.getComponentDescriptor(WagonManager.ROLE);
                desc.setImplementation(NbWagonManager.class.getName());
                desc = plexusContainer.getComponentDescriptor(KnownHostsProvider.ROLE, "file");
                desc.getConfiguration().getChild("hostKeyChecking").setValue("no");
                desc = plexusContainer.getComponentDescriptor(KnownHostsProvider.ROLE, "null");
                desc.getConfiguration().getChild("hostKeyChecking").setValue("no");
            }
        });
        MavenEmbedder embedder = null;
        try {
            embedder = new MavenEmbedder((Configuration)req);
            try {
                WagonManager wagonManager = (WagonManager)embedder.getPlexusContainer().lookup(WagonManager.ROLE);
                wagonManager.setInteractive(false);
            }
            catch (ComponentLookupException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        catch (MavenEmbedderException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return embedder;
    }

    public static synchronized MavenEmbedder getProjectEmbedder() {
        MavenEmbedder projectEmbedder;
        if (!wasReset) {
            projectEmbedder = projectTL.get();
        } else {
            projectEmbedder = project;
            projectTL.remove();
        }
        if (projectEmbedder == null) {
            MavenEmbedder embedder = EmbedderFactory.createProjectLikeEmbedder();
            if (!wasReset) {
                projectTL.set(embedder);
            } else {
                project = embedder;
            }
            projectEmbedder = embedder;
        }
        return projectEmbedder;
    }

    public static synchronized MavenEmbedder getOnlineEmbedder() {
        return EmbedderFactory.createOnlineEmbedder();
    }

    static MavenEmbedder createOnlineEmbedder() {
        DefaultConfiguration req = new DefaultConfiguration();
        req.setClassLoader(EmbedderFactory.class.getClassLoader());
        EmbedderFactory.setLocalRepoPreference((Configuration)req);
        req.addActiveProfile("netbeans-public").addActiveProfile("netbeans-private");
        File userSettingsPath = MavenEmbedder.DEFAULT_USER_SETTINGS_FILE;
        File globalSettingsPath = InstalledFileLocator.getDefault().locate("maven2/settings.xml", null, false);
        ConfigurationValidationResult cvr = MavenEmbedder.validateConfiguration((Configuration)req);
        Exception userSettingsException = cvr.getUserSettingsException();
        if (userSettingsException != null) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)userSettingsException, (String)"Maven Settings file cannot be properly parsed. Until it's fixed, it will be ignored."));
        }
        if (cvr.isValid()) {
            req.setUserSettingsFile(userSettingsPath);
        } else {
            LOG.info("Maven settings file is corrupted. See http://www.netbeans.org/issues/show_bug.cgi?id=96919");
            req.setUserSettingsFile(globalSettingsPath);
        }
        req.setGlobalSettingsFile(globalSettingsPath);
        Properties props = EmbedderFactory.copySystemProperties();
        req.setSystemProperties(EmbedderFactory.fillEnvVars(props));
        req.setConfigurationCustomizer(new ContainerCustomizer(){

            public void customize(PlexusContainer plexusContainer) {
                ComponentDescriptor desc = plexusContainer.getComponentDescriptor(KnownHostsProvider.ROLE, "file");
                desc.getConfiguration().getChild("hostKeyChecking").setValue("no");
                desc = plexusContainer.getComponentDescriptor(KnownHostsProvider.ROLE, "null");
                desc.getConfiguration().getChild("hostKeyChecking").setValue("no");
            }
        });
        req.setMavenEmbedderLogger((MavenEmbedderLogger)new NullEmbedderLogger());
        MavenEmbedder embedder = null;
        try {
            embedder = new MavenEmbedder((Configuration)req);
            try {
                WagonManager wagonManager = (WagonManager)embedder.getPlexusContainer().lookup(WagonManager.ROLE);
                wagonManager.setInteractive(false);
                wagonManager.setDownloadMonitor((TransferListener)new ProgressTransferListener());
            }
            catch (ComponentLookupException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        catch (MavenEmbedderException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return embedder;
    }

    public static MavenEmbedder createExecuteEmbedder(MavenEmbedderLogger logger) {
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        ClassWorld world = new ClassWorld();
        File rootPackageFolder = InstalledFileLocator.getDefault().locate("maven2/rootpackage", null, false);
        if (rootPackageFolder != null) {
            rootPackageFolder = FileUtil.normalizeFile((File)rootPackageFolder);
        }
        try {
            ClassRealm nbRealm = world.newRealm("netbeans", loader);
            ClassRealm plexusRealm = world.newRealm("plexus.core", loader.getParent());
            plexusRealm.importFrom(nbRealm.getId(), "org.codehaus.doxia");
            plexusRealm.importFrom(nbRealm.getId(), "org.codehaus.plexus");
            plexusRealm.importFrom(nbRealm.getId(), "org.codehaus.classworlds");
            plexusRealm.importFrom(nbRealm.getId(), "org.apache.maven");
            plexusRealm.importFrom(nbRealm.getId(), "org.apache.commons");
            plexusRealm.importFrom(nbRealm.getId(), "org.apache.log4j");
            plexusRealm.importFrom(nbRealm.getId(), "org.apache.xbean");
            plexusRealm.importFrom(nbRealm.getId(), "org.apache.xerces");
            plexusRealm.importFrom(nbRealm.getId(), "META-INF/maven");
            plexusRealm.importFrom(nbRealm.getId(), "META-INF/plexus");
            plexusRealm.importFrom(nbRealm.getId(), "com.jcraft.jsch");
            plexusRealm.importFrom(nbRealm.getId(), "org.aspectj");
            plexusRealm.importFrom(nbRealm.getId(), "org.cyberneko");
            plexusRealm.importFrom(nbRealm.getId(), "org.easymock");
            plexusRealm.importFrom(nbRealm.getId(), "hidden.org.codehaus.plexus");
            plexusRealm.importFrom(nbRealm.getId(), "org.openide.util");
            plexusRealm.importFrom(nbRealm.getId(), "org.netbeans.modules.maven.bridges");
            plexusRealm.importFrom(nbRealm.getId(), "org.netbeans.modules.maven.embedder.exec");
            if (rootPackageFolder != null) {
                plexusRealm.addURL(rootPackageFolder.toURI().toURL());
            }
        }
        catch (NoSuchRealmException ex) {
            ex.printStackTrace();
        }
        catch (DuplicateRealmException ex) {
            ex.printStackTrace();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        DefaultConfiguration req = new DefaultConfiguration();
        req.setClassWorld(world);
        req.setMavenEmbedderLogger(logger);
        EmbedderFactory.setLocalRepoPreference((Configuration)req);
        req.addActiveProfile("netbeans-public").addActiveProfile("netbeans-private");
        File userSettingsPath = MavenEmbedder.DEFAULT_USER_SETTINGS_FILE;
        File globalSettingsPath = InstalledFileLocator.getDefault().locate("maven2/settings.xml", null, false);
        ConfigurationValidationResult cvr = MavenEmbedder.validateConfiguration((Configuration)req);
        Exception userSettingsException = cvr.getUserSettingsException();
        if (userSettingsException != null) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)userSettingsException, (String)"Maven Settings file cannot be properly parsed. Until it's fixed, it will be ignored."));
        }
        if (userSettingsPath.exists()) {
            if (cvr.isValid()) {
                req.setUserSettingsFile(userSettingsPath);
            } else {
                LOG.info("Maven settings file is corrupted. See http://www.netbeans.org/issues/show_bug.cgi?id=96919");
                req.setUserSettingsFile(globalSettingsPath);
            }
        }
        req.setGlobalSettingsFile(globalSettingsPath);
        req.setConfigurationCustomizer(new ContainerCustomizer(){

            public void customize(PlexusContainer plexusContainer) {
                XmlPlexusConfiguration conf;
                PlexusConfiguration oldConf;
                ComponentDescriptor desc = plexusContainer.getComponentDescriptor(LifecycleExecutor.ROLE);
                desc.setImplementation(MyLifecycleExecutor.class.getName());
                try {
                    oldConf = desc.getConfiguration();
                    conf = new XmlPlexusConfiguration(oldConf.getName());
                    EmbedderFactory.copyConfig(oldConf, conf);
                    desc.setConfiguration((PlexusConfiguration)conf);
                }
                catch (PlexusConfigurationException ex) {
                    ex.printStackTrace();
                }
                desc = plexusContainer.getComponentDescriptor(BuildPlanner.class.getName());
                desc.setImplementation(NBBuildPlanner.class.getName());
                try {
                    oldConf = desc.getConfiguration();
                    conf = new XmlPlexusConfiguration(oldConf.getName());
                    EmbedderFactory.copyConfig(oldConf, conf);
                    desc.setConfiguration((PlexusConfiguration)conf);
                }
                catch (PlexusConfigurationException ex) {
                    ex.printStackTrace();
                }
            }
        });
        MavenEmbedder embedder = null;
        try {
            embedder = new MavenEmbedder((Configuration)req);
        }
        catch (MavenEmbedderException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return embedder;
    }

    public static ArtifactRepository createRemoteRepository(MavenEmbedder embedder, String url, String id) {
        try {
            ArtifactRepositoryFactory fact = (ArtifactRepositoryFactory)embedder.getPlexusContainer().lookup(ArtifactRepositoryFactory.ROLE);
            ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, "always", "warn");
            ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, "always", "warn");
            return fact.createArtifactRepository(id, url, "default", snapshotsPolicy, releasesPolicy);
        }
        catch (UnknownRepositoryLayoutException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ComponentLookupException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static ModelLineage createModelLineage(File pom, MavenEmbedder embedder, boolean allowStubs) throws ProjectBuildingException {
        try {
            ModelLineageBuilder bldr = (ModelLineageBuilder)embedder.getPlexusContainer().lookup(ModelLineageBuilder.class);
            DefaultProfileActivationContext context = new DefaultProfileActivationContext(new Properties(), true);
            DefaultProfileManager manager = new DefaultProfileManager(embedder.getPlexusContainer(), (ProfileActivationContext)context);
            DefaultProjectBuilderConfiguration conf = new DefaultProjectBuilderConfiguration();
            conf.setGlobalProfileManager((ProfileManager)manager);
            conf.setExecutionProperties(new Properties());
            conf.setLocalRepository(embedder.getLocalRepository());
            conf.setUserProperties(new Properties());
            return bldr.buildModelLineage(pom, (ProjectBuilderConfiguration)conf, new ArrayList(), allowStubs, true);
        }
        catch (ComponentLookupException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new DefaultModelLineage();
        }
    }

    private static void copyConfig(PlexusConfiguration old, XmlPlexusConfiguration conf) throws PlexusConfigurationException {
        int i;
        conf.setValue(old.getValue());
        String[] attrNames = old.getAttributeNames();
        if (attrNames != null && attrNames.length > 0) {
            for (i = 0; i < attrNames.length; ++i) {
                conf.setAttribute(attrNames[i], old.getAttribute(attrNames[i]));
            }
        }
        if ("lifecycle".equals(conf.getName())) {
            conf.setAttribute("implementation", "org.apache.maven.lifecycle.Lifecycle");
        }
        for (i = 0; i < old.getChildCount(); ++i) {
            PlexusConfiguration oldChild = old.getChild(i);
            XmlPlexusConfiguration newChild = new XmlPlexusConfiguration(oldChild.getName());
            conf.addChild((PlexusConfiguration)newChild);
            EmbedderFactory.copyConfig(oldChild, newChild);
        }
    }

    public static Properties fillEnvVars(Properties properties) {
        try {
            Properties envVars = CommandLineUtils.getSystemEnvVars();
            for (Map.Entry<Object, Object> e : envVars.entrySet()) {
                properties.setProperty("env." + e.getKey().toString(), e.getValue().toString());
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties;
    }

    static {
        fileListener = new SettingsFileListener();
        LOG = Logger.getLogger(EmbedderFactory.class.getName());
    }

    private static class SettingsFileListener
    extends FileChangeAdapter {
        private FileObject dir;

        public SettingsFileListener() {
            File userLoc = FileUtil.normalizeFile((File)MavenEmbedder.DEFAULT_USER_SETTINGS_FILE.getParentFile());
            try {
                this.dir = FileUtil.toFileObject((File)userLoc);
                if (this.dir == null) {
                    this.dir = FileUtil.createFolder((File)userLoc);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (this.dir != null) {
                this.dir.addFileChangeListener((FileChangeListener)this);
                FileObject settings = this.dir.getFileObject("settings.xml");
                if (settings != null) {
                    settings.addFileChangeListener((FileChangeListener)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fileDeleted(FileEvent fe) {
            if (!"settings.xml".equals(fe.getFile().getNameExt())) return;
            fe.getFile().removeFileChangeListener((FileChangeListener)this);
            Class<EmbedderFactory> clazz = EmbedderFactory.class;
            synchronized (EmbedderFactory.class) {
                online = null;
                project = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fileDataCreated(FileEvent fe) {
            if (!"settings.xml".equals(fe.getFile().getNameExt())) return;
            fe.getFile().addFileChangeListener((FileChangeListener)this);
            Class<EmbedderFactory> clazz = EmbedderFactory.class;
            synchronized (EmbedderFactory.class) {
                online = null;
                project = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fileChanged(FileEvent fe) {
            if (!"settings.xml".equals(fe.getFile().getNameExt())) return;
            Class<EmbedderFactory> clazz = EmbedderFactory.class;
            synchronized (EmbedderFactory.class) {
                online = null;
                project = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

