/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.IndexManager;

public final class DocumentBasedIndexManager {
    private static DocumentBasedIndexManager instance;
    private final Map<URL, DocumentIndex> indexes = new HashMap<URL, DocumentIndex>();

    private DocumentBasedIndexManager() {
    }

    public static synchronized DocumentBasedIndexManager getDefault() {
        if (instance == null) {
            instance = new DocumentBasedIndexManager();
        }
        return instance;
    }

    public synchronized DocumentIndex getIndex(URL root, Mode mode) throws IOException {
        assert (root != null);
        DocumentIndex li = this.indexes.get(root);
        if (li == null) {
            try {
                switch (mode) {
                    case CREATE: {
                        File file = new File(root.toURI());
                        file.mkdir();
                        li = IndexManager.createDocumentIndex((File)file);
                        this.indexes.put(root, li);
                        break;
                    }
                    case IF_EXIST: {
                        String[] children;
                        File file = new File(root.toURI());
                        if (!file.isDirectory() || (children = file.list()) == null || children.length <= 0) break;
                        li = IndexManager.createDocumentIndex((File)file);
                        this.indexes.put(root, li);
                        break;
                    }
                }
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return li;
    }

    public static enum Mode {
        OPENED,
        CREATE,
        IF_EXIST;

    }
}

