/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.impl.CheckNode;
import org.netbeans.modules.refactoring.spi.impl.CheckNodeListener;
import org.netbeans.modules.refactoring.spi.impl.CheckRenderer;
import org.netbeans.modules.refactoring.spi.impl.InvalidationListener;
import org.netbeans.modules.refactoring.spi.impl.ParametersPanel;
import org.netbeans.modules.refactoring.spi.impl.PreviewManager;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanelContainer;
import org.netbeans.modules.refactoring.spi.impl.UndoManager;
import org.netbeans.modules.refactoring.spi.impl.UndoWatcher;
import org.netbeans.modules.refactoring.spi.ui.RefactoringCustomUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactoryImplementation;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class RefactoringPanel
extends JPanel
implements InvalidationListener {
    private static final RequestProcessor RP = new RequestProcessor(RefactoringPanel.class.getName(), 1, false, false);
    private transient JTree tree = null;
    private transient JButton refreshButton = null;
    private transient JToggleButton expandButton = null;
    private JToolBar toolBar = null;
    private transient JButton refactorButton = null;
    private transient JButton cancelButton = null;
    private transient ButtonL buttonListener = null;
    private transient JButton rerunButton = null;
    private final RefactoringUI ui;
    private final boolean isQuery;
    private transient boolean isVisible = false;
    private transient RefactoringSession session = null;
    private transient ParametersPanel parametersPanel = null;
    private transient JScrollPane scrollPane = null;
    private transient JPanel southPanel;
    public JSplitPane splitPane;
    private JPanel left;
    private Action callback = null;
    private static final int MAX_ROWS = 50;
    private transient JToggleButton logicalViewButton = null;
    private transient JToggleButton physicalViewButton = null;
    private transient JToggleButton customViewButton = null;
    private transient ProgressListener progressListener;
    private transient JButton prevMatch = null;
    private transient JButton nextMatch = null;
    private WeakReference<TopComponent> refCallerTC;
    private boolean inited = false;
    private Component customComponent;
    static Image PACKAGE_BADGE = ImageUtilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageBadge.gif");
    private static final byte LOGICAL = 0;
    private static final byte PHYSICAL = 1;
    private static final byte GRAPHICAL = 2;
    private static final String PREF_VIEW_TYPE = "PREF_VIEW_TYPE";
    private byte currentView = this.getPrefViewType();
    RequestProcessor rp = new RequestProcessor();
    private int location;

    public RefactoringPanel(RefactoringUI ui) {
        this(ui, null);
    }

    public RefactoringPanel(RefactoringUI ui, TopComponent caller) {
        if (caller != null) {
            this.refCallerTC = new WeakReference<TopComponent>(caller);
        }
        this.ui = ui;
        this.isQuery = ui.isQuery();
        this.refresh(true);
    }

    public RefactoringPanel(RefactoringUI ui, RefactoringSession session, Action callback) {
        this.session = session;
        this.ui = ui;
        this.isQuery = ui.isQuery();
        this.callback = callback;
        this.initialize();
        this.refresh(false);
    }

    public static void checkEventThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("This must happen in event thread!"));
        }
    }

    private void initialize() {
        GridBagConstraints c;
        if (this.inited) {
            return;
        }
        RefactoringPanel.checkEventThread();
        this.setFocusCycleRoot(true);
        this.splitPane = new JSplitPane(1);
        this.left = new JPanel();
        this.splitPane.setLeftComponent(this.left);
        this.left.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        if (!this.isQuery) {
            this.splitPane.setRightComponent(new JLabel(NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Preview_not_Available"), 0));
        }
        JButton[] buttons = this.getButtons();
        this.southPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < buttons.length; ++i) {
            c = new GridBagConstraints();
            c.gridy = 0;
            c.insets = new Insets(5, 5, 5, 0);
            this.southPanel.add((Component)buttons[i], c);
        }
        JPanel pp = new JPanel(new BorderLayout());
        c = new GridBagConstraints();
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.fill = 2;
        this.southPanel.add((Component)pp, c);
        if (!this.isQuery || this.callback != null) {
            this.left.add((Component)this.southPanel, "South");
        }
        JToolBar toolBar = this.getToolBar();
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            toolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
            this.southPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        if (toolBar != null) {
            this.left.add((Component)toolBar, "West");
        }
        this.validate();
        this.inited = true;
    }

    private JToolBar getToolBar() {
        RefactoringPanel.checkEventThread();
        this.refreshButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/refresh.png", (boolean)false));
        Dimension dim = new Dimension(24, 24);
        this.refreshButton.setMaximumSize(dim);
        this.refreshButton.setMinimumSize(dim);
        this.refreshButton.setPreferredSize(dim);
        this.refreshButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_refresh"));
        this.refreshButton.addActionListener(this.getButtonListener());
        this.expandButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/expandTree.png", (boolean)false));
        this.expandButton.setSelectedIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/colapseTree.png", (boolean)false));
        this.expandButton.setMaximumSize(dim);
        this.expandButton.setMinimumSize(dim);
        this.expandButton.setPreferredSize(dim);
        this.expandButton.setSelected(true);
        this.expandButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_expandAll"));
        this.expandButton.addActionListener(this.getButtonListener());
        this.toolBar = new JToolBar(1);
        this.toolBar.setFloatable(false);
        this.logicalViewButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/logical_view.png", (boolean)false));
        this.logicalViewButton.setMaximumSize(dim);
        this.logicalViewButton.setMinimumSize(dim);
        this.logicalViewButton.setPreferredSize(dim);
        this.logicalViewButton.setSelected(this.currentView == 0);
        this.logicalViewButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_logicalView"));
        this.logicalViewButton.addActionListener(this.getButtonListener());
        this.physicalViewButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/file_view.png", (boolean)false));
        this.physicalViewButton.setMaximumSize(dim);
        this.physicalViewButton.setMinimumSize(dim);
        this.physicalViewButton.setPreferredSize(dim);
        this.physicalViewButton.setSelected(this.currentView == 1);
        this.physicalViewButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_physicalView"));
        this.physicalViewButton.addActionListener(this.getButtonListener());
        if (!Utilities.isMac()) {
            this.refreshButton.setMnemonic(NbBundle.getMessage(RefactoringPanel.class, (String)"MNEM_refresh").charAt(0));
            this.expandButton.setMnemonic(NbBundle.getMessage(RefactoringPanel.class, (String)"MNEM_expandAll").charAt(0));
            this.logicalViewButton.setMnemonic(NbBundle.getMessage(RefactoringPanel.class, (String)"MNEM_logicalView").charAt(0));
            this.physicalViewButton.setMnemonic(NbBundle.getMessage(RefactoringPanel.class, (String)"MNEM_physicalView").charAt(0));
        }
        if (this.ui instanceof RefactoringCustomUI) {
            this.customViewButton = new JToggleButton(((RefactoringCustomUI)((Object)this.ui)).getCustomIcon());
            this.customViewButton.setMaximumSize(dim);
            this.customViewButton.setMinimumSize(dim);
            this.customViewButton.setPreferredSize(dim);
            this.customViewButton.setSelected(this.currentView == 2);
            this.customViewButton.setToolTipText(((RefactoringCustomUI)((Object)this.ui)).getCustomToolTip());
            this.customViewButton.addActionListener(this.getButtonListener());
        }
        this.nextMatch = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/nextmatch.png", (boolean)false));
        this.nextMatch.setMaximumSize(dim);
        this.nextMatch.setMinimumSize(dim);
        this.nextMatch.setPreferredSize(dim);
        this.nextMatch.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_nextMatch"));
        this.nextMatch.addActionListener(this.getButtonListener());
        this.prevMatch = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/prevmatch.png", (boolean)false));
        this.prevMatch.setMaximumSize(dim);
        this.prevMatch.setMinimumSize(dim);
        this.prevMatch.setPreferredSize(dim);
        this.prevMatch.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_prevMatch"));
        this.prevMatch.addActionListener(this.getButtonListener());
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.expandButton);
        this.toolBar.add(this.logicalViewButton);
        this.toolBar.add(this.physicalViewButton);
        if (this.ui instanceof RefactoringCustomUI) {
            this.toolBar.add(this.customViewButton);
        }
        this.toolBar.add(this.prevMatch);
        this.toolBar.add(this.nextMatch);
        return this.toolBar;
    }

    private JButton[] getButtons() {
        RefactoringPanel.checkEventThread();
        if (this.isQuery) {
            this.refactorButton = null;
            if (this.callback == null) {
                return new JButton[0];
            }
            this.rerunButton = new JButton((String)this.callback.getValue("Name"));
            this.rerunButton.addActionListener(this.getButtonListener());
            return new JButton[]{this.rerunButton};
        }
        this.refactorButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.refactorButton, (String)NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_DoRefactor"));
        this.refactorButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_DoRefactor"));
        this.refactorButton.addActionListener(this.getButtonListener());
        this.cancelButton = new JButton(NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_CancelRefactor"));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_CancelRefactor"));
        this.cancelButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_CancelRefactor"));
        this.cancelButton.addActionListener(this.getButtonListener());
        return new JButton[]{this.refactorButton, this.cancelButton};
    }

    void switchToLogicalView() {
        this.logicalViewButton.setSelected(true);
        if (this.currentView == 0) {
            return;
        }
        this.currentView = 0;
        this.physicalViewButton.setSelected(false);
        if (this.customViewButton != null) {
            this.customViewButton.setSelected(false);
            this.prevMatch.setEnabled(true);
            this.nextMatch.setEnabled(true);
            this.expandButton.setEnabled(true);
        }
        this.storePrefViewType();
        this.refresh(false);
    }

    void switchToPhysicalView() {
        this.physicalViewButton.setSelected(true);
        if (this.currentView == 1) {
            return;
        }
        this.currentView = 1;
        this.logicalViewButton.setSelected(false);
        if (this.customViewButton != null) {
            this.customViewButton.setSelected(false);
            this.prevMatch.setEnabled(true);
            this.nextMatch.setEnabled(true);
            this.expandButton.setEnabled(true);
        }
        this.storePrefViewType();
        this.refresh(false);
    }

    void switchToCustomView() {
        this.customViewButton.setSelected(true);
        if (this.currentView == 2) {
            return;
        }
        this.currentView = (byte)2;
        this.logicalViewButton.setSelected(false);
        this.physicalViewButton.setSelected(false);
        this.prevMatch.setEnabled(false);
        this.nextMatch.setEnabled(false);
        this.expandButton.setEnabled(false);
        this.refresh(false);
    }

    private CheckNode createNode(TreeElement representedObject, Map<Object, CheckNode> nodes, CheckNode root) {
        boolean isLogical = this.currentView == 0;
        CheckNode node = null;
        node = representedObject instanceof SourceGroup ? nodes.get(((SourceGroup)representedObject).getRootFolder()) : nodes.get(representedObject);
        if (node != null) {
            return node;
        }
        TreeElement parent = representedObject.getParent(isLogical);
        String displayName = representedObject.getText(isLogical);
        Icon icon = representedObject.getIcon();
        node = new CheckNode(representedObject, displayName, icon);
        CheckNode parentNode = parent == null ? root : this.createNode(parent, nodes, root);
        parentNode.add(node);
        if (representedObject instanceof SourceGroup) {
            nodes.put(((SourceGroup)representedObject).getRootFolder(), node);
        } else {
            nodes.put(representedObject, node);
        }
        return node;
    }

    private static final String getString(String key) {
        return NbBundle.getMessage(RefactoringPanel.class, (String)key);
    }

    protected void updateTitle() {
    }

    private void refactor() {
        RefactoringPanel.checkEventThread();
        RefactoringPanel.disableComponents(this);
        this.progressListener = new ProgressL();
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RefactoringPanel.this.session.addProgressListener(RefactoringPanel.this.progressListener);
                    RefactoringPanel.this.session.doRefactoring(true);
                    RefactoringPanel.this.session.removeProgressListener(RefactoringPanel.this.progressListener);
                    RefactoringPanel.this.progressListener.stop(null);
                }
                catch (Throwable throwable) {
                    RefactoringPanel.this.session.removeProgressListener(RefactoringPanel.this.progressListener);
                    RefactoringPanel.this.progressListener.stop(null);
                    RefactoringPanel.this.progressListener = null;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RefactoringPanel.this.close();
                        }
                    });
                    throw throwable;
                }
                RefactoringPanel.this.progressListener = null;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private int cancel() {
        RefactoringPanel.checkEventThread();
        this.close();
        return 0;
    }

    void close() {
        if (this.isQuery) {
            RefactoringPanelContainer.getUsagesComponent().removePanel(this);
        } else {
            RefactoringPanelContainer.getRefactoringComponent().removePanel(this);
        }
        this.closeNotify();
    }

    private ButtonL getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new ButtonL();
        }
        return this.buttonListener;
    }

    public void expandAll() {
        RefactoringPanel.checkEventThread();
        Cursor old = this.getCursor();
        this.expandButton.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
        }
        this.setCursor(old);
        this.expandButton.setEnabled(true);
        this.expandButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_collapseAll"));
        this.requestFocus();
    }

    public void collapseAll() {
        RefactoringPanel.checkEventThread();
        this.expandButton.setEnabled(false);
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int row = this.tree.getRowCount() - 1; row > 0; --row) {
            this.tree.collapseRow(row);
        }
        this.setCursor(old);
        this.expandButton.setEnabled(true);
        this.expandButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_expandAll"));
        this.requestFocus();
    }

    @Override
    public void invalidateObject() {
        if (this.isQuery) {
            return;
        }
        Runnable invalidate = new Runnable(){

            @Override
            public void run() {
                RefactoringPanel.this.setRefactoringEnabled(false, false);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            invalidate.run();
        } else {
            SwingUtilities.invokeLater(invalidate);
        }
    }

    private void refresh(final boolean showParametersPanel) {
        RefactoringPanel.checkEventThread();
        if (showParametersPanel) {
            RefactoringSession tempSession;
            if (this.parametersPanel == null) {
                this.parametersPanel = new ParametersPanel(this.ui);
            }
            if ((tempSession = this.parametersPanel.showDialog()) == null) {
                if (!this.parametersPanel.isCanceledDialog()) {
                    this.close();
                }
                return;
            }
            if (tempSession.getRefactoringElements().isEmpty()) {
                DialogDescriptor nd = new DialogDescriptor((Object)NbBundle.getMessage(ParametersPanel.class, (String)"MSG_NoPatternsFound"), this.ui.getName(), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, this.ui.getHelpCtx(), null);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                return;
            }
            this.session = tempSession;
        }
        this.initialize();
        final String description = this.ui.getDescription();
        this.setToolTipText("<html>" + description + "</html>");
        final Collection<RefactoringElement> elements = this.session.getRefactoringElements();
        this.setName(this.ui.getName());
        if (this.ui instanceof RefactoringCustomUI) {
            if (this.customComponent == null) {
                this.customComponent = ((RefactoringCustomUI)((Object)this.ui)).getCustomComponent(elements);
            }
            this.left.remove(this.customComponent);
        }
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RefactoringPanel.class, (String)(this.isQuery ? "LBL_PreparingUsagesTree" : "LBL_PreparingRefactoringTree")));
        if (this.currentView == 2) {
            assert (this.ui instanceof RefactoringCustomUI);
            assert (this.customComponent != null);
            RefactoringCustomUI cui = (RefactoringCustomUI)((Object)this.ui);
            this.left.remove(this.scrollPane);
            this.left.add(this.customComponent, "Center");
            UI.setComponentForRefactoringPreview(null);
            this.splitPane.validate();
            this.repaint();
            this.tree = null;
        } else {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashSet<CloneableEditorSupport> editorSupports = new HashSet<CloneableEditorSupport>();
                    int errorsNum = 0;
                    if (!RefactoringPanel.this.isQuery) {
                        for (RefactoringElement elem : elements) {
                            if (elem.getStatus() != 2 && elem.getStatus() != 3) continue;
                            ++errorsNum;
                        }
                    }
                    int occurencesNum = elements.size();
                    StringBuffer errorsDesc = new StringBuffer();
                    errorsDesc.append(" [" + occurencesNum);
                    errorsDesc.append(' ');
                    errorsDesc.append(occurencesNum == 1 ? NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Occurence") : NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Occurences"));
                    if (errorsNum > 0) {
                        errorsDesc.append(',');
                        errorsDesc.append(' ');
                        errorsDesc.append("<font color=#CC0000>" + errorsNum);
                        errorsDesc.append(' ');
                        errorsDesc.append(errorsNum == 1 ? NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Error") : NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Errors"));
                        errorsDesc.append("</font>");
                    }
                    errorsDesc.append(']');
                    final CheckNode root = new CheckNode(RefactoringPanel.this.ui, description + errorsDesc.toString(), ImageUtilities.loadImageIcon((String)("org/netbeans/modules/refactoring/api/resources/" + (RefactoringPanel.this.isQuery ? "findusages.png" : "refactoring.gif")), (boolean)false));
                    HashMap nodes = new HashMap();
                    Cursor old = RefactoringPanel.this.getCursor();
                    RefactoringPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    progressHandle.start(elements.size() / 10);
                    int i = 0;
                    try {
                        for (RefactoringElement e : elements) {
                            RefactoringPanel.this.createNode(TreeElementFactory.getTreeElement(e), nodes, root);
                            PositionBounds pb = e.getPosition();
                            if (pb != null) {
                                CloneableEditorSupport ces = pb.getBegin().getCloneableEditorSupport();
                                editorSupports.add(ces);
                            }
                            if (i % 10 == 0) {
                                progressHandle.progress(i / 10);
                            }
                            ++i;
                        }
                        UndoManager.getDefault().watch(editorSupports, RefactoringPanel.this);
                        RefactoringPanel.this.sortTree(root);
                    }
                    catch (RuntimeException t) {
                        RefactoringPanel.this.cleanupTreeElements();
                        throw t;
                    }
                    catch (Error e) {
                        RefactoringPanel.this.cleanupTreeElements();
                        throw e;
                    }
                    finally {
                        progressHandle.finish();
                        RefactoringPanel.this.setCursor(old);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (RefactoringPanel.this.tree == null) {
                                RefactoringPanel.this.tree = new JTree(root);
                                if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                                    RefactoringPanel.this.tree.setBackground(UIManager.getColor("NbExplorerView.background"));
                                }
                                ToolTipManager.sharedInstance().registerComponent(RefactoringPanel.this.tree);
                                RefactoringPanel.this.tree.setCellRenderer(new CheckRenderer(RefactoringPanel.this.isQuery, RefactoringPanel.this.tree.getBackground()));
                                String s = NbBundle.getMessage(RefactoringPanel.class, (String)"ACSD_usagesTree");
                                RefactoringPanel.this.tree.getAccessibleContext().setAccessibleDescription(s);
                                RefactoringPanel.this.tree.getAccessibleContext().setAccessibleName(s);
                                CheckNodeListener l = new CheckNodeListener(RefactoringPanel.this.isQuery);
                                RefactoringPanel.this.tree.addMouseListener(l);
                                RefactoringPanel.this.tree.addKeyListener(l);
                                RefactoringPanel.this.tree.setToggleClickCount(0);
                                RefactoringPanel.this.tree.setTransferHandler(new TransferHandlerImpl());
                                RefactoringPanel.this.scrollPane = new JScrollPane(RefactoringPanel.this.tree);
                                RefactoringPanel.this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                                RefactoringPanel.this.left.add((Component)RefactoringPanel.this.scrollPane, "Center");
                                RefactoringPanel.this.validate();
                            } else {
                                RefactoringPanel.this.tree.setModel(new DefaultTreeModel(root));
                            }
                            RefactoringPanel.this.tree.setRowHeight((int)((CheckRenderer)RefactoringPanel.this.tree.getCellRenderer()).getPreferredSize().getHeight());
                            if (showParametersPanel) {
                                RefactoringPanel.this.splitPane.setDividerLocation(0.3);
                                if (elements.size() < 50) {
                                    RefactoringPanel.this.expandAll();
                                    if (!RefactoringPanel.this.isQuery) {
                                        RefactoringPanel.this.selectNextUsage();
                                    }
                                } else {
                                    RefactoringPanel.this.expandButton.setSelected(false);
                                }
                            } else if (RefactoringPanel.this.expandButton.isSelected()) {
                                RefactoringPanel.this.expandAll();
                                if (!RefactoringPanel.this.isQuery) {
                                    RefactoringPanel.this.selectNextUsage();
                                }
                            } else {
                                RefactoringPanel.this.expandButton.setSelected(false);
                            }
                            RefactoringPanel.this.tree.setSelectionRow(0);
                            RefactoringPanel.this.requestFocus();
                            RefactoringPanel.this.setRefactoringEnabled(true, true);
                            if (RefactoringPanel.this.parametersPanel != null && ((Boolean)RefactoringPanel.this.parametersPanel.getClientProperty("JUMP_TO_FIRST_OCCURENCE")).booleanValue()) {
                                RefactoringPanel.this.selectNextUsage();
                            }
                        }
                    });
                }
            });
        }
        if (!this.isVisible) {
            RefactoringPanelContainer cont = this.isQuery ? RefactoringPanelContainer.getUsagesComponent() : RefactoringPanelContainer.getRefactoringComponent();
            cont.open();
            cont.requestActive();
            if (this.isQuery && this.parametersPanel != null && !this.parametersPanel.isCreateNewTab()) {
                cont.removePanel(null);
            }
            cont.addPanel(this);
            this.isVisible = true;
        }
        this.setRefactoringEnabled(false, true);
    }

    private void sortTree(CheckNode root) {
        CheckNode node;
        int i;
        ArrayList<CheckNode> nodes = new ArrayList<CheckNode>();
        ArrayList<CheckNode> leaves = new ArrayList<CheckNode>();
        for (i = 0; i < root.getChildCount(); ++i) {
            node = (CheckNode)root.getChildAt(i);
            if (node.isLeaf()) continue;
            this.sortTree(node);
            nodes.add(node);
        }
        for (i = 0; i < root.getChildCount(); ++i) {
            node = (CheckNode)root.getChildAt(i);
            if (!node.isLeaf()) continue;
            leaves.add(node);
        }
        Collections.sort(nodes, new Comparator<CheckNode>(){

            @Override
            public int compare(CheckNode o1, CheckNode o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        root.removeAllChildren();
        for (CheckNode checkNode : nodes) {
            root.add(checkNode);
        }
        for (CheckNode checkNode : leaves) {
            root.add(checkNode);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.refactorButton != null) {
            this.refactorButton.requestFocus();
        } else if (this.tree != null) {
            this.tree.requestFocus();
        }
    }

    void setRefactoringEnabled(boolean enabled, boolean isRefreshing) {
        RefactoringPanel.checkEventThread();
        if (this.tree != null) {
            if (!enabled) {
                CheckNode c = (CheckNode)this.tree.getModel().getRoot();
                if (!isRefreshing) {
                    c.setNeedsRefresh();
                } else {
                    c.setDisabled();
                }
                this.tree.setModel(new DefaultTreeModel(c, false));
            }
            this.tree.setEnabled(enabled);
            if (this.refactorButton != null) {
                this.refactorButton.setEnabled(enabled);
            }
        }
    }

    private static void disableComponents(Container c) {
        RefactoringPanel.checkEventThread();
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isEnabled()) {
                children[i].setEnabled(false);
            }
            if (!(children[i] instanceof Container)) continue;
            RefactoringPanel.disableComponents((Container)children[i]);
        }
    }

    void selectNextUsage() {
        CheckNodeListener.selectNextPrev(true, this.isQuery, this.tree);
    }

    void selectPrevUsage() {
        CheckNodeListener.selectNextPrev(false, this.isQuery, this.tree);
    }

    public void storeDividerLocation() {
        if (this.splitPane.getRightComponent() != null) {
            this.location = this.splitPane.getDividerLocation();
        }
    }

    public void restoreDeviderLocation() {
        if (this.splitPane.getRightComponent() != null) {
            this.splitPane.setDividerLocation(this.location);
        }
    }

    private byte getPrefViewType() {
        Preferences prefs = NbPreferences.forModule(RefactoringPanel.class);
        return (byte)prefs.getInt(PREF_VIEW_TYPE, 1);
    }

    private void storePrefViewType() {
        assert (this.currentView != 2);
        Preferences prefs = NbPreferences.forModule(RefactoringPanel.class);
        prefs.putInt(PREF_VIEW_TYPE, this.currentView);
    }

    private static String normalize(String input) {
        int size = input.length();
        char[] c = new char[size];
        input.getChars(0, size, c, 0);
        boolean wb = false;
        int pos = 0;
        char[] nc = new char[size];
        for (int i = 0; i < size; ++i) {
            if (Character.isWhitespace(c[i])) {
                if (wb) continue;
                nc[pos++] = 32;
                wb = true;
                continue;
            }
            nc[pos++] = c[i];
            wb = false;
        }
        return new String(nc, 0, pos);
    }

    protected void closeNotify() {
        TopComponent tc;
        UndoWatcher.stopWatching(this);
        if (this.tree != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.tree);
            this.scrollPane.getViewport().remove(this.tree);
        }
        if (this.scrollPane != null) {
            this.scrollPane.setViewport(null);
        }
        if (this.refCallerTC != null && (tc = (TopComponent)this.refCallerTC.get()) != null && tc.isShowing()) {
            tc.requestActive();
        }
        this.cleanupTreeElements();
        PreviewManager.getDefault().clean(this);
        this.tree = null;
        this.session = null;
        this.parametersPanel = null;
    }

    private void cleanupTreeElements() {
        for (TreeElementFactoryImplementation tefi : Lookup.getDefault().lookupAll(TreeElementFactoryImplementation.class)) {
            tefi.cleanUp();
        }
    }

    private static class Html2Text
    extends HTMLEditorKit.ParserCallback {
        StringBuffer s;

        public void parse(Reader in) throws IOException {
            this.s = new StringBuffer();
            ParserDelegator delegator = new ParserDelegator();
            delegator.parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char[] text, int pos) {
            this.s.append(text);
        }

        public String getText() {
            return this.s.toString();
        }
    }

    private static class ResultTransferable
    implements Transferable {
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;
        private static DataFlavor[] htmlFlavors;
        protected String plainData;
        protected String htmlData;

        public ResultTransferable(String plainData, String htmlData) {
            this.plainData = plainData;
            this.htmlData = htmlData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            int nHtml = this.isHtmlSupported() ? htmlFlavors.length : 0;
            int nPlain = this.isPlainSupported() ? plainFlavors.length : 0;
            int nString = this.isPlainSupported() ? stringFlavors.length : 0;
            int nFlavors = nHtml + nPlain + nString;
            DataFlavor[] flavors = new DataFlavor[nFlavors];
            int nDone = 0;
            if (nHtml > 0) {
                System.arraycopy(htmlFlavors, 0, flavors, nDone, nHtml);
                nDone += nHtml;
            }
            if (nPlain > 0) {
                System.arraycopy(plainFlavors, 0, flavors, nDone, nPlain);
                nDone += nPlain;
            }
            if (nString > 0) {
                System.arraycopy(stringFlavors, 0, flavors, nDone, nString);
                nDone += nString;
            }
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isHtmlFlavor(flavor)) {
                String html = this.getHtmlData();
                String string = html = html == null ? "" : html;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return html;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(html);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new StringBufferInputStream(html);
                }
            } else if (this.isPlainFlavor(flavor)) {
                String data = this.getPlainData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new StringBufferInputStream(data);
                }
            } else if (this.isStringFlavor(flavor)) {
                String data = this.getPlainData();
                data = data == null ? "" : data;
                return data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        protected boolean isPlainFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = plainFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = stringFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHtmlFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = htmlFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHtmlSupported() {
            return this.htmlData != null;
        }

        protected String getHtmlData() {
            return this.htmlData;
        }

        static {
            block2: {
                try {
                    htmlFlavors = new DataFlavor[3];
                    ResultTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
                    ResultTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
                    ResultTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
                    plainFlavors = new DataFlavor[3];
                    ResultTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                    ResultTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                    ResultTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                    stringFlavors = new DataFlavor[2];
                    ResultTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                    ResultTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
                }
                catch (ClassNotFoundException cle) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)cle);
                }
            }
        }
    }

    private static class TransferHandlerImpl
    extends TransferHandler {
        private TransferHandlerImpl() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTree) {
                JTree tree = (JTree)c;
                TreePath[] paths = tree.getSelectionPaths();
                if (paths == null || paths.length == 0) {
                    return null;
                }
                Html2Text html2Text = new Html2Text();
                StringBuilder plain = new StringBuilder();
                StringBuilder html = new StringBuilder("<html><ul>");
                int depth = 1;
                for (TreePath path : paths) {
                    String label;
                    block8: {
                        while (depth < path.getPathCount()) {
                            html.append("<ul>");
                            ++depth;
                        }
                        while (depth > path.getPathCount()) {
                            html.append("</ul>");
                            --depth;
                        }
                        Object o = path.getLastPathComponent();
                        if (!(o instanceof CheckNode)) continue;
                        CheckNode node = (CheckNode)o;
                        label = node.getLabel();
                        try {
                            html2Text.parse(new StringReader(label));
                        }
                        catch (IOException ex) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError((Object)ex);
                        }
                    }
                    plain.append(html2Text.getText());
                    plain.append("\n");
                    html.append("<li>");
                    html.append(label);
                    html.append("</li>");
                }
                while (depth > 1) {
                    html.append("</ul>");
                    --depth;
                }
                html.append("</ul></html>");
                return new ResultTransferable(plain.toString(), html.toString());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private static class ProgressL
    implements ProgressListener {
        private ProgressHandle handle;
        private Dialog d;
        private int counter;

        private ProgressL() {
        }

        @Override
        public void start(final ProgressEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressL.this.counter = 0;
                    String lab = NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_RefactorProgressLabel");
                    ProgressL.this.handle = ProgressHandleFactory.createHandle((String)lab);
                    JComponent progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)ProgressL.this.handle);
                    JPanel component = new JPanel();
                    component.setLayout(new BorderLayout());
                    component.setBorder(new EmptyBorder(12, 12, 11, 11));
                    JLabel label = new JLabel(lab);
                    label.setBorder(new EmptyBorder(0, 0, 6, 0));
                    component.add((Component)label, "North");
                    component.add((Component)progress, "Center");
                    DialogDescriptor desc = new DialogDescriptor((Object)component, NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_RefactoringInProgress"), true, new Object[0], null, 0, null, null);
                    desc.setLeaf(true);
                    ProgressL.this.d = DialogDisplayer.getDefault().createDialog(desc);
                    ((JDialog)ProgressL.this.d).setDefaultCloseOperation(0);
                    ProgressL.this.handle.start(event.getCount());
                    ProgressL.this.d.setVisible(true);
                }
            });
        }

        @Override
        public void step(ProgressEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProgressL.this.handle.progress(++ProgressL.this.counter);
                    }
                    catch (Throwable e) {
                        ErrorManager.getDefault().notify(1, e);
                    }
                }
            });
        }

        @Override
        public void stop(final ProgressEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (event != null) {
                        ProgressL.this.handle.finish();
                    }
                    ProgressL.this.d.setVisible(false);
                }
            });
        }
    }

    private class ButtonL
    implements ActionListener {
        private ButtonL() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object o = event.getSource();
            if (o == RefactoringPanel.this.cancelButton) {
                RefactoringPanel.this.cancel();
            } else if (o == RefactoringPanel.this.refactorButton) {
                RefactoringPanel.this.refactor();
            } else if (o == RefactoringPanel.this.rerunButton) {
                RefactoringPanel.this.close();
                RefactoringPanel.this.callback.actionPerformed(event);
            } else if (o == RefactoringPanel.this.expandButton && RefactoringPanel.this.tree != null) {
                if (RefactoringPanel.this.expandButton.isSelected()) {
                    RefactoringPanel.this.expandAll();
                } else {
                    RefactoringPanel.this.collapseAll();
                }
            } else if (o == RefactoringPanel.this.refreshButton) {
                if (RefactoringPanel.this.callback != null) {
                    RefactoringPanel.this.close();
                    RefactoringPanel.this.callback.actionPerformed(event);
                } else {
                    RefactoringPanel.this.refresh(true);
                }
            } else if (o == RefactoringPanel.this.physicalViewButton) {
                RefactoringPanel.this.switchToPhysicalView();
            } else if (o == RefactoringPanel.this.logicalViewButton) {
                RefactoringPanel.this.switchToLogicalView();
            } else if (o == RefactoringPanel.this.customViewButton) {
                RefactoringPanel.this.switchToCustomView();
            } else if (o == RefactoringPanel.this.nextMatch) {
                RefactoringPanel.this.selectNextUsage();
            } else if (o == RefactoringPanel.this.prevMatch) {
                RefactoringPanel.this.selectPrevUsage();
            }
        }
    }
}

