/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.watchers;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.watchers.WatchersInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.util.BugLog;

public class WatchersBuilder
implements Builder {
    private static final String UNKNOWN_FILE = "? ";
    private WatchersInformation watchersInfo;
    private final EventManager eventManager;
    private final String localPath;

    public WatchersBuilder(EventManager eventManager, String string) {
        this.eventManager = eventManager;
        this.localPath = string;
    }

    public void outputDone() {
        if (this.watchersInfo != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.watchersInfo));
            this.watchersInfo = null;
        }
    }

    public void parseLine(String string, boolean bl) {
        if (string.startsWith(UNKNOWN_FILE)) {
            File file = new File(this.localPath, string.substring(UNKNOWN_FILE.length()));
            this.watchersInfo = new WatchersInformation(file);
            this.outputDone();
            return;
        }
        if (bl) {
            return;
        }
        if (string.startsWith(" ") || string.startsWith("\t")) {
            BugLog.getInstance().assertNotNull(this.watchersInfo);
            this.watchersInfo.addWatcher(string);
            return;
        }
        this.outputDone();
        String string2 = string.trim().replace('\t', ' ');
        int n = string2.indexOf(32);
        BugLog.getInstance().assertTrue(n > 0, "Wrong line = " + string);
        File file = new File(this.localPath, string2.substring(0, n));
        String string3 = string2.substring(n + 1);
        this.watchersInfo = new WatchersInformation(file);
        this.watchersInfo.addWatcher(string3);
    }

    public void parseEnhancedMessage(String string, Object object) {
    }
}

