/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.archetype.metadata.io.xpp3.ArchetypeDescriptorXpp3Reader;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.maven.newproject.AddOSGiParamToNbmPluginConfiguration;
import org.netbeans.modules.maven.newproject.BasicEEWizardIterator;
import org.netbeans.modules.maven.newproject.MavenWizardIterator;
import org.netbeans.modules.maven.newproject.ProjectInfo;
import org.netbeans.modules.maven.options.MavenCommandSettings;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ArchetypeWizardUtils {
    static final String OSGIDEPENDENCIES = "osgi.dependencies";
    private static final String USER_DIR_PROP = "user.dir";
    private static final RequestProcessor RP = new RequestProcessor(ArchetypeWizardUtils.class);
    public static Archetype[] WEB_APP_ARCHS;
    public static Archetype[] EJB_ARCHS;
    public static Archetype[] EAR_ARCHS;
    public static final Archetype EA_ARCH;
    public static final Archetype NB_MODULE_ARCH;
    public static final Archetype NB_APP_ARCH;
    public static final Archetype NB_SUITE_ARCH;
    public static final Archetype OSGI_ARCH;
    public static final String[] EE_LEVELS;
    private static final String loggerName = "org.netbeans.ui.metrics.maven";
    private static final String loggerKey = "USG_PROJECT_CREATE_MAVEN";

    private ArchetypeWizardUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runArchetype(File directory, ProjectInfo vi, Archetype arch, Map<String, String> additional) throws IOException {
        Properties props = new Properties();
        props.setProperty("artifactId", vi.artifactId);
        props.setProperty("version", vi.version);
        props.setProperty("groupId", vi.groupId);
        String pack = vi.packageName;
        if (pack != null && pack.trim().length() > 0) {
            props.setProperty("package", pack);
        }
        props.setProperty("archetypeArtifactId", arch.getArtifactId());
        props.setProperty("archetypeGroupId", arch.getGroupId());
        props.setProperty("archetypeVersion", arch.getVersion());
        props.setProperty("basedir", directory.getAbsolutePath());
        if (additional != null) {
            for (String key : additional.keySet()) {
                props.setProperty(key, additional.get(key));
            }
        }
        BeanRunConfig config = new BeanRunConfig();
        config.setActivatedProfiles(Collections.<String>emptyList());
        config.setExecutionDirectory(directory);
        config.setExecutionName(NbBundle.getMessage(ArchetypeWizardUtils.class, (String)"RUN_Project_Creation"));
        config.setGoals(Collections.singletonList(MavenCommandSettings.getDefault().getCommand("createArchetypeNG")));
        if (arch.getRepository() != null) {
            props.setProperty("archetype.repository", arch.getRepository());
            props.setProperty("archetypeRepository", arch.getRepository());
        }
        config.setInteractive(false);
        props.setProperty("archetype.interactive", "false");
        config.setProperties(props);
        if (arch.getVersion().contains("SNAPSHOT")) {
            config.setUpdateSnapshots(true);
        }
        config.setTaskDisplayName(NbBundle.getMessage(ArchetypeWizardUtils.class, (String)"RUN_Maven"));
        String oldUserdir = System.getProperty(USER_DIR_PROP);
        System.setProperty(USER_DIR_PROP, directory.getAbsolutePath());
        try {
            ExecutorTask task = RunUtils.executeMaven(config);
            task.result();
        }
        finally {
            if (oldUserdir == null) {
                System.getProperties().remove(USER_DIR_PROP);
            } else {
                System.setProperty(USER_DIR_PROP, oldUserdir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getAdditionalProperties(Artifact art) {
        HashMap<String, String> map = new HashMap<String, String>();
        File fil = art.getFile();
        JarFile jf = null;
        try {
            InputStream in;
            InputStreamReader rd;
            ArchetypeDescriptorXpp3Reader reader;
            ArchetypeDescriptor desc;
            List lst;
            jf = new JarFile(fil);
            JarEntry entry = jf.getJarEntry("META-INF/maven/archetype-metadata.xml");
            if (entry != null && (lst = (desc = (reader = new ArchetypeDescriptorXpp3Reader()).read(rd = new InputStreamReader(in = jf.getInputStream(entry)))).getRequiredProperties()) != null && lst.size() > 0) {
                for (RequiredProperty prop : lst) {
                    map.put(prop.getKey(), prop.getDefaultValue());
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ArchetypeWizardUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        catch (XmlPullParserException ex) {
            Logger.getLogger(ArchetypeWizardUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<FileObject> instantiate(ProgressHandle handle, WizardDescriptor wiz) throws IOException {
        ProjectInfo vi = new ProjectInfo();
        vi.groupId = (String)wiz.getProperty("groupId");
        vi.artifactId = (String)wiz.getProperty("artifactId");
        vi.version = (String)wiz.getProperty("version");
        vi.packageName = (String)wiz.getProperty("package");
        Archetype arch = (Archetype)wiz.getProperty("archetype");
        ArchetypeWizardUtils.logUsage(arch.getGroupId(), arch.getArtifactId(), arch.getVersion());
        Boolean setOsgiDeps = (Boolean)wiz.getProperty(OSGIDEPENDENCIES);
        Map additional = (Map)wiz.getProperty("additionalProps");
        try {
            ProjectInfo ear_vi = (ProjectInfo)wiz.getProperty("ear_versionInfo");
            if (ear_vi != null) {
                ProjectInfo web_vi = (ProjectInfo)wiz.getProperty("web_versionInfo");
                ProjectInfo ejb_vi = (ProjectInfo)wiz.getProperty("ejb_versionInfo");
                handle.start(8 + (web_vi != null ? 3 : 0) + (ejb_vi != null ? 3 : 0));
                File rootFile = ArchetypeWizardUtils.createFromArchetype(handle, (File)wiz.getProperty("projdir"), vi, arch, additional, 0);
                File earFile = ArchetypeWizardUtils.createFromArchetype(handle, (File)wiz.getProperty("ear_projdir"), ear_vi, (Archetype)wiz.getProperty("ear_archetype"), null, 4);
                int progressCounter = 6;
                if (web_vi != null) {
                    ArchetypeWizardUtils.createFromArchetype(handle, (File)wiz.getProperty("web_projdir"), web_vi, (Archetype)wiz.getProperty("web_archetype"), null, progressCounter);
                    progressCounter += 3;
                }
                if (ejb_vi != null) {
                    ArchetypeWizardUtils.createFromArchetype(handle, (File)wiz.getProperty("ejb_projdir"), ejb_vi, (Archetype)wiz.getProperty("ejb_archetype"), null, progressCounter);
                    progressCounter += 3;
                }
                ArchetypeWizardUtils.addEARDeps((File)wiz.getProperty("ear_projdir"), ejb_vi, web_vi, progressCounter);
                ArchetypeWizardUtils.updateProjectName(rootFile, NbBundle.getMessage(ArchetypeWizardUtils.class, (String)"TXT_EAProjectName", (Object)vi.artifactId));
                Set<FileObject> set = ArchetypeWizardUtils.openProjects(handle, rootFile, earFile, progressCounter);
                return set;
            }
            String nbm_artifactId = (String)wiz.getProperty("nbm_artifactId");
            handle.start(nbm_artifactId == null ? 4 : 7);
            File projFile = ArchetypeWizardUtils.createFromArchetype(handle, (File)wiz.getProperty("projdir"), vi, arch, additional, 0);
            File appDir = new File(projFile, "application");
            if (nbm_artifactId != null && projFile.exists()) {
                ProjectInfo nbm = new ProjectInfo();
                nbm.artifactId = nbm_artifactId;
                nbm.groupId = vi.groupId;
                nbm.version = vi.version;
                nbm.packageName = vi.packageName;
                File nbm_folder = ArchetypeWizardUtils.createFromArchetype(handle, new File(projFile, nbm_artifactId), nbm, NB_MODULE_ARCH, null, 3);
                ArchetypeWizardUtils.trimInheritedFromNbmProject(nbm_folder);
                if (NB_APP_ARCH.equals(arch)) {
                    ArchetypeWizardUtils.addModuleToApplication(appDir, nbm, null);
                }
            }
            if (setOsgiDeps != null && setOsgiDeps.booleanValue()) {
                ArchetypeWizardUtils.addNbmPluginOsgiParameter(projFile);
            }
            Set<FileObject> set = ArchetypeWizardUtils.openProjects(handle, projFile, appDir, nbm_artifactId == null ? 3 : 6);
            return set;
        }
        finally {
            handle.finish();
        }
    }

    private static void addNbmPluginOsgiParameter(File projFile) throws IOException {
        FileObject pom;
        FileObject prjDir = FileUtil.toFileObject((File)projFile);
        if (prjDir != null && (pom = prjDir.getFileObject("pom.xml")) != null) {
            Project prj = ProjectManager.getDefault().findProject(prjDir);
            NbMavenProject mav = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
            AddOSGiParamToNbmPluginConfiguration op = new AddOSGiParamToNbmPluginConfiguration(true, mav.getMavenProject());
            Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(op));
        }
    }

    private static void trimInheritedFromNbmProject(File projFile) throws IOException {
        FileObject pom;
        FileObject prjDir = FileUtil.toFileObject((File)projFile);
        if (prjDir != null && (pom = prjDir.getFileObject("pom.xml")) != null) {
            TrimInheritedFromNbmProject op = new TrimInheritedFromNbmProject();
            Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(op));
        }
    }

    private static void logUsage(String groupId, String artifactId, String version) {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        logRecord.setParameters(new Object[]{groupId + ":" + artifactId + ":" + version});
        Logger.getLogger(loggerName).log(logRecord);
    }

    private static File createFromArchetype(ProgressHandle handle, File projDir, ProjectInfo vi, Archetype arch, Map<String, String> additional, int progressCounter) throws IOException {
        handle.progress(++progressCounter);
        File dirF = FileUtil.normalizeFile((File)projDir);
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        dirF.getParentFile().mkdirs();
        handle.progress(NbBundle.getMessage(MavenWizardIterator.class, (String)"PRG_Processing_Archetype"), ++progressCounter);
        ArchetypeWizardUtils.runArchetype(dirF.getParentFile(), vi, arch, additional);
        handle.progress(++progressCounter);
        return dirF;
    }

    private static Set<FileObject> openProjects(ProgressHandle handle, File dirF, File mainProjectDir, int progressCounter) throws IOException {
        ArrayList<FileObject> resultList = new ArrayList<FileObject>();
        FileObject fDir = FileUtil.toFileObject((File)dirF);
        if (fDir != null) {
            FileObject mainFO = FileUtil.toFileObject((File)mainProjectDir);
            resultList.add(fDir);
            ArchetypeWizardUtils.processProjectFolder(fDir, null);
            FileObject nbAppModuleDir = ArchetypeWizardUtils.findNbAppProjectDir(fDir);
            Enumeration e = fDir.getFolders(true);
            while (e.hasMoreElements()) {
                FileObject subfolder = (FileObject)e.nextElement();
                if (!ProjectManager.getDefault().isProject(subfolder)) continue;
                if (subfolder.equals(mainFO)) {
                    resultList.add(0, subfolder);
                } else {
                    resultList.add(subfolder);
                }
                ArchetypeWizardUtils.processProjectFolder(subfolder, nbAppModuleDir);
            }
        }
        handle.progress(++progressCounter);
        return new LinkedHashSet<FileObject>(resultList);
    }

    private static void processProjectFolder(FileObject fo, FileObject nbAppModuleDir) {
        try {
            Project prj = ProjectManager.getDefault().findProject(fo);
            if (prj == null) {
                return;
            }
            final NbMavenProject watch = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
            if (watch != null) {
                if (!"pom".equals(watch.getPackagingType())) {
                    URI mainJava = FileUtilities.convertStringToUri(watch.getMavenProject().getBuild().getSourceDirectory());
                    URI testJava = FileUtilities.convertStringToUri(watch.getMavenProject().getBuild().getTestSourceDirectory());
                    File file = new File(mainJava);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (!(file = new File(testJava)).exists()) {
                        file.mkdirs();
                    }
                    if (nbAppModuleDir != null && "nbm".equals(watch.getPackagingType())) {
                        ArchetypeWizardUtils.storeNbAppModuleDirInfo(prj, nbAppModuleDir);
                    }
                }
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        watch.downloadDependencyAndJavadocSource();
                    }
                });
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static FileObject findNbAppProjectDir(FileObject dir) throws IOException {
        FileObject res = null;
        Enumeration e = dir.getFolders(false);
        while (e.hasMoreElements()) {
            NbMavenProject watch;
            Project prj;
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder) || (prj = ProjectManager.getDefault().findProject(subfolder)) == null || (watch = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class)) == null || !"nbm-application".equals(watch.getPackagingType())) continue;
            res = subfolder;
            break;
        }
        return res;
    }

    private static void storeNbAppModuleDirInfo(Project prj, FileObject nbAppModuleDir) {
        AuxiliaryProperties auxConfig = (AuxiliaryProperties)prj.getLookup().lookup(AuxiliaryProperties.class);
        auxConfig.put("pathToNbApplicationModule", "../application", true);
    }

    private static void addEARDeps(File earDir, ProjectInfo ejbVi, ProjectInfo webVi, int progressCounter) {
        FileObject earDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)earDir));
        if (earDirFO == null) {
            return;
        }
        ArrayList<AddDependencyOperation> operations = new ArrayList<AddDependencyOperation>();
        if (ejbVi != null) {
            operations.add(new AddDependencyOperation(ejbVi, "ejb"));
        }
        if (webVi != null) {
            operations.add(new AddDependencyOperation(webVi, "war"));
        }
        Utilities.performPOMModelOperations((FileObject)earDirFO.getFileObject("pom.xml"), operations);
        ++progressCounter;
    }

    private static void addModuleToApplication(File file, ProjectInfo nbm, Object object) {
        FileObject appPrjFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (appPrjFO == null) {
            return;
        }
        ArrayList<AddDependencyOperation> operations = new ArrayList<AddDependencyOperation>();
        operations.add(new AddDependencyOperation(nbm, null));
        Utilities.performPOMModelOperations((FileObject)appPrjFO.getFileObject("pom.xml"), operations);
    }

    private static void updateProjectName(File projDir, final String newName) {
        FileObject pomFO = FileUtil.toFileObject((File)new File(projDir, "pom.xml"));
        if (pomFO != null) {
            ModelOperation<POMModel> op = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    model.getProject().setName(newName);
                }
            };
            Utilities.performPOMModelOperations((FileObject)pomFO, Collections.singletonList(op));
        }
    }

    static {
        EE_LEVELS = new String[]{NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_JEE6"), NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_JEE5"), NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_J2EE14")};
        WEB_APP_ARCHS = new Archetype[3];
        Archetype arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.0.2");
        arch.setArtifactId("webapp-javaee6");
        ArchetypeWizardUtils.WEB_APP_ARCHS[0] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.0.1");
        arch.setArtifactId("webapp-jee5");
        ArchetypeWizardUtils.WEB_APP_ARCHS[1] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.0.1");
        arch.setArtifactId("webapp-j2ee14");
        ArchetypeWizardUtils.WEB_APP_ARCHS[2] = arch;
        EJB_ARCHS = new Archetype[3];
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.0.2");
        arch.setArtifactId("ejb-javaee6");
        ArchetypeWizardUtils.EJB_ARCHS[0] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.0.1");
        arch.setArtifactId("ejb-jee5");
        ArchetypeWizardUtils.EJB_ARCHS[1] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.0.1");
        arch.setArtifactId("ejb-j2ee14");
        ArchetypeWizardUtils.EJB_ARCHS[2] = arch;
        EAR_ARCHS = new Archetype[3];
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.0");
        arch.setArtifactId("ear-javaee6");
        ArchetypeWizardUtils.EAR_ARCHS[0] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.0.1");
        arch.setArtifactId("ear-jee5");
        ArchetypeWizardUtils.EAR_ARCHS[1] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.0.1");
        arch.setArtifactId("ear-j2ee14");
        ArchetypeWizardUtils.EAR_ARCHS[2] = arch;
        EA_ARCH = new Archetype();
        EA_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        EA_ARCH.setVersion("1.0.1");
        EA_ARCH.setArtifactId("pom-root");
        NB_MODULE_ARCH = new Archetype();
        NB_MODULE_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        NB_MODULE_ARCH.setVersion("1.4");
        NB_MODULE_ARCH.setArtifactId("nbm-archetype");
        NB_MODULE_ARCH.setRepository("http://repository.codehaus.org/");
        NB_APP_ARCH = new Archetype();
        NB_APP_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        NB_APP_ARCH.setVersion("1.5");
        NB_APP_ARCH.setArtifactId("netbeans-platform-app-archetype");
        NB_APP_ARCH.setRepository("http://repository.codehaus.org/");
        NB_SUITE_ARCH = new Archetype();
        NB_SUITE_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        NB_SUITE_ARCH.setVersion("1.1");
        NB_SUITE_ARCH.setArtifactId("nbm-suite-root");
        NB_SUITE_ARCH.setRepository("http://repository.codehaus.org/");
        OSGI_ARCH = new Archetype();
        OSGI_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        OSGI_ARCH.setVersion("1.0");
        OSGI_ARCH.setArtifactId("osgi-archetype");
        OSGI_ARCH.setRepository("http://repository.codehaus.org/");
    }

    private static class AddDependencyOperation
    implements ModelOperation<POMModel> {
        private final String group;
        private final String artifact;
        private final String version;
        private final String type;

        public AddDependencyOperation(ProjectInfo info, String type) {
            this.group = info.groupId;
            this.artifact = info.artifactId;
            this.version = info.version;
            this.type = type;
        }

        public AddDependencyOperation(String g, String a, String v, String t) {
            this.group = g;
            this.artifact = a;
            this.version = v;
            this.type = t;
        }

        public void performOperation(POMModel model) {
            Dependency dep = ModelUtils.checkModelDependency(model, this.group, this.artifact, true);
            dep.setVersion(this.version);
            dep.setType(this.type);
        }
    }

    private static class TrimInheritedFromNbmProject
    implements ModelOperation<POMModel> {
        private TrimInheritedFromNbmProject() {
        }

        public void performOperation(POMModel model) {
            List deps;
            Build b;
            List pr;
            org.netbeans.modules.maven.model.pom.Project p = model.getProject();
            p.setGroupId(null);
            List reps = p.getRepositories();
            if (reps != null) {
                for (Repository r : reps) {
                    p.removeRepository(r);
                }
            }
            if ((pr = p.getPluginRepositories()) != null) {
                for (Repository r : pr) {
                    p.removePluginRepository(r);
                }
            }
            if ((b = p.getBuild()) != null) {
                Plugin pl = b.findPluginById("org.codehaus.mojo", "nbm-maven-plugin");
                if (pl != null) {
                    pl.setConfiguration(null);
                    pl.setVersion(null);
                }
                if ((pl = b.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin")) != null) {
                    b.removePlugin(pl);
                }
            }
            if ((deps = p.getDependencies()) != null) {
                for (Dependency d : deps) {
                    if (!d.getGroupId().startsWith("org.netbeans")) continue;
                    d.setVersion("${netbeans.version}");
                }
            }
        }
    }
}

