/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.InputStream;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.StreamFeeder;
import org.codehaus.plexus.util.cli.StreamPumper;

public abstract class CommandLineUtils {
    public static int executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommandLine(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        Process p = cl.execute();
        StreamFeeder inputFeeder = null;
        if (systemIn != null) {
            inputFeeder = new StreamFeeder(systemIn, p.getOutputStream());
        }
        StreamPumper outputPumper = new StreamPumper(p.getInputStream(), systemOut);
        StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), systemErr);
        if (inputFeeder != null) {
            inputFeeder.start();
        }
        outputPumper.start();
        errorPumper.start();
        try {
            Thread thread;
            int returnValue = p.waitFor();
            if (inputFeeder != null) {
                thread = inputFeeder;
                synchronized (thread) {
                    if (!inputFeeder.isDone()) {
                        inputFeeder.wait();
                    }
                }
            }
            if (outputPumper != null) {
                thread = outputPumper;
                synchronized (thread) {
                    if (!outputPumper.isDone()) {
                        outputPumper.wait();
                    }
                }
            }
            if (errorPumper != null) {
                thread = errorPumper;
                synchronized (thread) {
                    if (!errorPumper.isDone()) {
                        errorPumper.wait();
                    }
                }
            }
            int n = returnValue;
            Object var14_15 = null;
            if (inputFeeder != null) {
                inputFeeder.close();
            }
            outputPumper.close();
            errorPumper.close();
            return n;
        }
        catch (InterruptedException ex) {
            try {
                throw new CommandLineException("Error while executing external command.", ex);
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (inputFeeder != null) {
                    inputFeeder.close();
                }
                outputPumper.close();
                errorPumper.close();
                throw throwable;
            }
        }
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private StringBuffer string = new StringBuffer();
        private String ls = System.getProperty("line.separator");

        public void consumeLine(String line) {
            this.string.append(line + this.ls);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

