package cz.cuni.amis.pogamut.ut2004.examples.emptybot;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 * Pogamut's "Hello world!" example showing few extra things such as introspection
 * and various bot-initializing methods.
 * <p><p>
 * First, try to run the bot and kill it... than uncomment the line inside {@link EmptyBot#botKilled(BotKilled)} 
 * and run the bot again kill it to see the difference. 
 *
 * @author Michal Bida aka Knight
 * @author Rudolf Kadlec aka ik
 * @author Jakub Gemrot aka Jimmy
 */
@AgentScoped
public class EmptyBot extends UT2004BotModuleController {

    @JProp
    public String stringProp = "Hello bot example";
    @JProp
    public boolean boolProp = true;
    @JProp
    public int intProp = 2;
    @JProp
    public double doubleProp = 1.0;

    /**
     * Initialize all necessary variables here, before the bot actually receives anything
     * from the environment.
     */
    @Override
    public void prepareBot(UT2004Bot bot) {
    	// By uncommenting following line, you can make the bot to do the file logging of all its components
    	//bot.getLogger().addDefaultFileHandler(new File("EmptyBot.log"));
    }
    
    /**
     * Here we can modify initializing command for our bot, e.g., sets its name or skin.
     * @return instance of {@link Initialize}
     */
    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("EmptyBot");
    }
    
    /**
     * Handshake with GameBots2004 is over - bot has information about the map in its world view.
     * Many agent modules are usable since this method is called.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     */
    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    /**
     * The bot is initilized in the environment - a physical representation of the bot is present in the game.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     * @param self information about the agent
     */
    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        // Display a welcome message in the game engine
    	// right in the time when the bot appears in the environment, i.e., his body has just been spawned 
    	// into the UT2004 for the first time.    	
        body.getCommunication().sendGlobalTextMessage("Hello world! I am alive!");
        
        // alternatively, you may use getAct() method for issuing arbitrary {@link CommandMessage} for the bot's body
        // inside UT2004
        getAct().act(new SendMessage().setGlobal(true).setText("And I can speak! Hurray!"));
    }

    Player lastPlayer;

    /**
     * Main method that controls the bot - makes decisions what to do next.
     * It is called iteratively by Pogamut engine every time a synchronous batch
     * from the environment is received. This is usually 4 times per second - it
     * is affected by visionTime variable, that can be adjusted in GameBots ini file in
     * UT2004/System folder.
     *
     * @throws cz.cuni.amis.pogamut.base.exceptions.PogamutException
     */
    @Override
    public void logic() throws PogamutException {
        if (players.canSeePlayers()) {
            lastPlayer = players.getNearestVisiblePlayer();
            move.moveTo(players.getNearestVisiblePlayer());
        } else {
            if (lastPlayer == null) {
                move.turnHorizontal(30);
            } else {
                if (lastPlayer.getLocation().getDistance(info.getLocation()) < 200) {
                    move.turnTo(lastPlayer.getLocation());
                    if (info.isFacing(lastPlayer.getLocation())) {
                        lastPlayer = null;
                    }
                } else {
                    if (this.pathExecutor.isExecuting()) {
                        // WAIT TILL WE GET THERE
                    } else {
                        this.pathExecutor.followPath(
                                this.pathPlanner.computePath(
                                    info.getLocation(),
                                    lastPlayer.getLocation()
                                )
                        );
                    }
                }
            }
            
        }
    }

    /**
     * Called each time the bot dies. Good for reseting all bot's state dependent variables.
     *
     * @param event
     */
    @Override
    public void botKilled(BotKilled event) {
    	// First, try to run the bot and kill it... than uncomment this line and run the bot again
    	// kill it and see the difference.
        //body.getCommunication().sendGlobalTextMessage("I was KILLED!");
    }

    /**
     * This method is called when the bot is started either from IDE or from command line.
     *
     * @param args
     */
    public static void main(String args[]) throws PogamutException {
    	// wrapped logic for bots executions, suitable to run single bot in single JVM
    	new UT2004BotRunner(EmptyBot.class, "EmptyBot").setMain(true).startAgent();
    }
}
