/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.navigationbot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionHistoryStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;

@AgentScoped
public class NavigationBot
extends UT2004BotModuleController {
    protected TabooSet<NavPoint> tabooNavPoints;
    protected NavPoint targetNavPoint;

    public Initialize getInitializeCommand() {
        return new Initialize().setName("NavigationBot");
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.tabooNavPoints = new TabooSet(this.bot);
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector(this.bot, 3.0, 10.0));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionHistoryStuckDetector(this.bot));
        this.pathExecutor.getState().addStrongListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                switch (changedValue.getState()) {
                    case PATH_COMPUTATION_FAILED: 
                    case TARGET_REACHED: {
                        NavigationBot.this.goToRandomNavPoint();
                        break;
                    }
                    case STUCK: {
                        NavigationBot.this.tabooNavPoints.add((Object)NavigationBot.this.targetNavPoint, 10.0);
                        NavigationBot.this.targetNavPoint = NavigationBot.this.pickSecondNearestNavPoint();
                        if (NavigationBot.this.targetNavPoint == null) {
                            NavigationBot.this.targetNavPoint = NavigationBot.this.pickRandomNavPoint();
                        }
                        NavigationBot.this.pathExecutor.followPath(NavigationBot.this.pathPlanner.computePath((Object)NavigationBot.this.info.getLocation(), (Object)NavigationBot.this.targetNavPoint));
                    }
                }
            }
        });
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.goToRandomNavPoint();
        this.pathExecutor.getLog().setLevel(Level.ALL);
    }

    public void logic() throws PogamutException {
        this.log.info("--- Logic iteration ---");
        this.log.info("Visible navpoints: " + this.world.getAllVisible(NavPoint.class).size() + " / " + this.world.getAll(NavPoint.class).size());
        this.log.info("Visible items:     " + this.world.getAllVisible(Item.class).size() + " / " + this.world.getAll(Item.class).size());
    }

    public void botKilled(BotKilled event) {
        this.pathExecutor.stop();
    }

    protected void goToRandomNavPoint() {
        this.targetNavPoint = this.pickRandomNavPoint();
        IPathFuture pathHandle = this.pathPlanner.computePath((Object)this.info.getLocation(), (Object)this.targetNavPoint);
        this.pathExecutor.followPath(pathHandle);
    }

    protected NavPoint pickRandomNavPoint() {
        this.getLog().severe("Picking new target navpoint.");
        Set navPoints = this.tabooNavPoints.filter(this.getWorldView().getAll(NavPoint.class).values());
        NavPoint chosen = (NavPoint)MyCollections.getRandom((Collection)navPoints);
        if (chosen != null) {
            return chosen;
        }
        this.log.warning("All navpoints are tabooized at this moment, choosing navpoint randomly!");
        return (NavPoint)MyCollections.getRandom(this.getWorldView().getAll(NavPoint.class).values());
    }

    protected NavPoint pickSecondNearestNavPoint() {
        return (NavPoint)DistanceUtils.getSecondNearest((Collection)this.tabooNavPoints.filter(this.getWorldView().getAll(NavPoint.class).values()), (ILocated)this.info.getLocation());
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(NavigationBot.class, "NavigationBot").setMain(true).startAgent();
    }
}

