package cz.cuni.amis.pogamut.ut2004.examples.botwithparams;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 * This bot does not do anything - it is a show-case that will (hopefully) explain, how to create your own parameters for the bot,
 * and you will see how to obtain them during runtime. The advantage of parameterization is that you may have 1 class with MULTIPLE parameters
 * thus obtaining different behaviors with every instance of params.
 * <p><p>
 * There are two things you have to do:
 * <ol>
 * <li>you have to create new class that will extend {@link UT2004AgentParameters}, in the example implementation that is done by implementation {@link CustomBotParameters}</li>
 * <li>you have to instantiate that class and give it to {@link UT2004BotRunner#startAgents(UT2004AgentParameters...)}, that is carried out inside {@link BotWithParams#main(String[])}</li>
 * <li></li>
 * </ol>
 * After that, the runner will feed these params into the {@link UT2004Bot} class and they will become available through
 * {@link UT2004Bot#getParams()}. Notice, that you will need to cast these params to your class in order to use them.
 * For that we're recommend to create custom method inside your bot controller class that will do that for you.
 * <p><p>
 * Note that the implementation of this class is minimalistic, in order to show only methods that are needed. For the sake of simplicity, the bot's behavior
 * is stupid one ... it will either jump, or rotate or both (depending on the parameters obtained from  
 *
 * @author Jakub Gemrot aka Jimmy
 */
@AgentScoped
public class BotWithParams extends UT2004BotModuleController {

	/**
	 * This method returns the parameters of the bot, to be used. It is using {@link UT2004Bot#getParams()} and casts them
	 * to {@link CustomBotParameters} that is, this bot can't be used with different parameters (it will screw up).
	 * @return
	 */
	public CustomBotParameters getParams() {
		// notice the cast to CustomBotParameters
		// this method will fail if you do not start the bot with CustomBotParameters (which compiles, but fails during runtime)
		return (CustomBotParameters)bot.getParams();
	}
	
    /**
     * Here we can modify initializing command for our bot, e.g., sets its name, skin, skill level according to {@link BotWithParams#getParams()}, i.e., 
     * {@link CustomBotParameters#getName()}, {@link CustomBotParameters#getBotSkin()} and {@link CustomBotParameters#getSkillLevel()}.
     * @return instance of {@link Initialize}
     */
    @Override
    public Initialize getInitializeCommand() {
        return new Initialize()
        				.setName(getParams().getName())
        				.setSkin(getParams().getBotSkin())
        				.setDesiredSkill(getParams().getSkillLevel());
    }
    
    /**
     * Inside logic we're implementing jumping / turning behavior as instructed by {@link BotWithParams#getParams()}, i.e., {@link CustomBotParameters#isJumping()}
     * and {@link CustomBotParameters#isRotating()}.
     */
    @Override
    public void logic() throws PogamutException {
    	// now query your params, and act accordingly
    	if (getParams().isJumping()) {
    		move.jump();
    	}
    	if (getParams().isRotating()) {
    		move.turnHorizontal(90);
    	}
    }

    /**
     * This method is called when the bot is started either from IDE or from command line.
     * <p><p>
     * Notice the usage of {@link UT2004BotRunner#startAgents(UT2004AgentParameters...)} that is using
     * {@link CustomBotParameters}. Such method will start 4 bots with all combination of jumping/rotating behavior.
     *
     * @param args
     */
    public static void main(String args[]) throws PogamutException {
    	// wrapped logic for bots executions, suitable to run single bot in single JVM
    	// NOTE THAT YOU MUST EXPLICITELY PARAMETRIZE UT2004BotRunner OTHERWISE JVM WILL SCREW UP!
    	new UT2004BotRunner<UT2004Bot, CustomBotParameters>(BotWithParams.class, "BotWithParams").setMain(true)
    			// it will start 4 bots, all with different params exhibiting 4 different behaviors based on their parametrization
    			.startAgents(
    				// notice how setter chaining is simplifying all this :-)
    				new CustomBotParameters().setName("StandingStillBot").setBotSkin("HumanMaleA.MercMaleC").setSkillLevel(1).setJumping(false).setRotating(false),
    				new CustomBotParameters().setName("RotatingBot").setBotSkin("HumanFemaleA.MercFemaleB").setSkillLevel(2).setJumping(false).setRotating(true),
    				new CustomBotParameters().setName("JumpingBot").setBotSkin("HumanFemaleA.MercFemaleA").setSkillLevel(3).setJumping(true).setRotating(false),
    				new CustomBotParameters().setName("RotatingJumpingBot").setBotSkin("HumanMaleA.MercMaleA").setSkillLevel(4).setJumping(true).setRotating(true)    				
    			);
    }
}
