/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.ctfbot;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionHistoryStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.CTFBotParams;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.goals.CloseInOnEnemy;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.goals.GetEnemyFlag;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.goals.GetHealth;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.goals.GetItems;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.goals.GetOurFlag;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.goals.GoalManager;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;

@AgentScoped
public class CTFBot
extends UT2004BotModuleController<UT2004Bot> {
    @JProp
    public boolean shouldEngage = true;
    @JProp
    public boolean shouldPursue = true;
    @JProp
    public boolean shouldRearm = true;
    @JProp
    public boolean shouldCollectItems = true;
    @JProp
    public boolean shouldCollectHealth = true;
    @JProp
    public int healthLevel = 90;
    @JProp
    public int frags = 0;
    @JProp
    public int deaths = 0;
    protected GameInfo gameInfo;
    @JProp
    protected Location pathTarget;
    protected Player enemy = null;
    protected TabooSet<Item> tabooItems = null;
    protected GetItems getItemsGoal;
    protected boolean firstLogic = true;
    protected FlagInfo ourFlag;
    protected FlagInfo enemyFlag;
    protected Location ourBase;
    protected Location enemyBase;
    protected GoalManager goalManager = null;
    protected final Heatup targetHU = new Heatup(5000L);
    protected int notMoving = 0;

    public CTFBotParams getParams() {
        return (CTFBotParams)this.bot.getParams();
    }

    public Location getPathTarget() {
        return this.pathTarget;
    }

    @EventListener(eventClass=PlayerKilled.class)
    public void playerKilled(PlayerKilled event) {
        if (event.getKiller().equals((Object)this.info.getId())) {
            ++this.frags;
        }
        if (this.enemy == null) {
            return;
        }
        if (this.enemy.getId().equals((Object)event.getId())) {
            this.enemy = null;
        }
    }

    public void prepareBot(UT2004Bot bot) {
        this.tabooItems = new TabooSet(bot);
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004TimeStuckDetector(bot, 3.0, 10.0));
        this.pathExecutor.addStuckDetector((IStuckDetector)new UT2004PositionHistoryStuckDetector(bot));
        this.pathExecutor.getState().addListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                switch (changedValue.getState()) {
                    case STUCK: {
                        Item item = CTFBot.this.getItemsGoal.getItem();
                        if (item != null && CTFBot.this.pathTarget != null && item.getLocation().equals(CTFBot.this.pathTarget, 10.0)) {
                            CTFBot.this.tabooItems.add((Object)item, 10.0);
                        }
                        CTFBot.this.reset();
                        break;
                    }
                    case TARGET_REACHED: {
                        CTFBot.this.reset();
                    }
                }
            }
        });
        this.weaponPrefs.addGeneralPref(ItemType.MINIGUN, false);
        this.weaponPrefs.addGeneralPref(ItemType.MINIGUN, true);
        this.weaponPrefs.addGeneralPref(ItemType.LINK_GUN, false);
        this.weaponPrefs.addGeneralPref(ItemType.LIGHTNING_GUN, true);
        this.weaponPrefs.addGeneralPref(ItemType.SHOCK_RIFLE, true);
        this.weaponPrefs.addGeneralPref(ItemType.ROCKET_LAUNCHER, true);
        this.weaponPrefs.addGeneralPref(ItemType.LINK_GUN, true);
        this.weaponPrefs.addGeneralPref(ItemType.ASSAULT_RIFLE, true);
        this.weaponPrefs.addGeneralPref(ItemType.FLAK_CANNON, false);
        this.weaponPrefs.addGeneralPref(ItemType.FLAK_CANNON, true);
        this.weaponPrefs.addGeneralPref(ItemType.BIO_RIFLE, true);
        this.goalManager = new GoalManager(this.bot);
        this.goalManager.addGoal(new GetEnemyFlag(this));
        this.goalManager.addGoal(new GetOurFlag(this));
        this.goalManager.addGoal(new GetHealth(this));
        this.getItemsGoal = new GetItems(this);
        this.goalManager.addGoal(this.getItemsGoal);
        this.goalManager.addGoal(new CloseInOnEnemy(this));
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        this.gameInfo = gameInfo;
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setDesiredSkill(Integer.valueOf(this.getParams().getSkillLevel())).setSkin(this.getParams().getBotSkin()).setTeam(Integer.valueOf(this.getParams().getTeam()));
    }

    public void setPath(IPathFuture<ILocated> path) {
        this.pathTarget = ((ILocated)path.getPathTo()).getLocation();
        this.pathExecutor.followPath(path);
    }

    public boolean goTo(ILocated target) {
        if (target == null) {
            this.log.info("goTo: null");
            return false;
        }
        this.log.info(String.format("goTo: %s %s", target.toString(), this.info.getLocation()));
        if (this.pathExecutor.isExecuting()) {
            this.log.info("executing");
            if (target.getLocation().getDistance(this.getInfo().getLocation()) < 120.0) {
                return false;
            }
            if (this.pathTarget != null && target.getLocation().getDistance(this.pathTarget) < 120.0) {
                return false;
            }
        }
        this.setPath((IPathFuture<ILocated>)this.pathPlanner.computePath((Object)this.info.getLocation(), (Object)target));
        this.log.info("Moving Along Path. Distance: " + this.info.getLocation().getDistance(target.getLocation()));
        return true;
    }

    public boolean goTo(Location location) {
        if (location == null) {
            this.log.info("goTo: null");
            return false;
        }
        this.log.info(String.format("goTo: %s %s", location.toString(), this.info.getLocation()));
        if (this.pathExecutor.isExecuting()) {
            this.log.info("executing");
            if (location.getDistance(this.getInfo().getLocation()) < 120.0) {
                return false;
            }
            if (this.pathTarget != null && location.getDistance(this.pathTarget) < 120.0) {
                return false;
            }
        }
        this.setPath((IPathFuture<ILocated>)this.pathPlanner.computePath((Object)this.info.getLocation(), (Object)location));
        this.log.info("Moving Along Path. Distance: " + this.info.getLocation().getDistance(location));
        return true;
    }

    public boolean holdingOrSupporting() {
        FlagInfo ourFlag = this.getOurFlag();
        if (ourFlag == null) {
            return false;
        }
        UnrealId holderId = ourFlag.getHolder();
        if (holderId == null) {
            return false;
        }
        if (this.info.getId().equals((Object)holderId)) {
            return true;
        }
        Player holder = this.players.getPlayer(holderId);
        return holder.getTeam() == this.info.getTeam().intValue() && this.getInfo().getDistance((ILocated)holder) < 60.0;
    }

    public void updateFight() {
        if (this.enemy == null || this.enemy.isVisible()) {
            this.enemy = this.getPlayers().getNearestVisibleEnemy();
        }
        Player nearest_target = this.players.getNearestVisibleEnemy();
        if (this.enemy == null) {
            this.enemy = nearest_target;
        } else if (nearest_target == this.enemy) {
            this.targetHU.heat();
        } else if (this.targetHU.isCool()) {
            this.enemy = nearest_target;
        }
        this.shoot();
    }

    public void updateFight(Player newEnemy) {
        if (newEnemy == null || !newEnemy.isVisible()) {
            newEnemy = this.getPlayers().getNearestVisibleEnemy();
        }
        this.enemy = newEnemy;
        this.shoot();
    }

    public void shoot() {
        if (this.enemy != null && this.enemy.isVisible()) {
            this.shoot.shoot(this.weaponPrefs, (ILocated)this.enemy, new ItemType[0]);
        } else {
            this.shoot.stopShoot();
            this.enemy = null;
        }
    }

    protected void reset() {
        this.notMoving = 0;
        this.enemy = null;
        this.pathExecutor.stop();
    }

    @ObjectClassEventListener(objectClass=FlagInfo.class, eventClass=WorldObjectAppearedEvent.class)
    public void flagSighted(IWorldObjectEvent<FlagInfo> event) {
        if (((FlagInfo)event.getObject()).getTeam() == this.getInfo().getTeam()) {
            this.ourFlag = (FlagInfo)event.getObject();
        } else {
            this.enemyFlag = (FlagInfo)event.getObject();
        }
        this.log.info(String.format("Flag: %s", ((FlagInfo)event.getObject()).toString()));
    }

    public Location getOurFlagBase() {
        return this.ourBase;
    }

    public Location getEnemyFlagBase() {
        return this.enemyBase;
    }

    public FlagInfo getOurFlag() {
        return this.ourFlag;
    }

    public FlagInfo getEnemyFlag() {
        return this.enemyFlag;
    }

    public Player getEnemy() {
        return this.enemy;
    }

    public void logic() {
        if (this.firstLogic) {
            this.firstLogic = false;
            switch (this.info.getTeam()) {
                case 0: {
                    this.ourBase = this.gameInfo.getRedBaseLocation();
                    this.enemyBase = this.gameInfo.getBlueBaseLocation();
                    break;
                }
                case 1: {
                    this.ourBase = this.gameInfo.getBlueBaseLocation();
                    this.enemyBase = this.gameInfo.getRedBaseLocation();
                }
            }
        }
        this.goalManager.executeBestGoal();
    }

    public TabooSet<Item> getTaboo() {
        return this.tabooItems;
    }

    public void botKilled(BotKilled event) {
        this.reset();
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(CTFBot.class, "CTFBot").setMain(true).startAgents((IAgentParameters[])new CTFBotParams[]{new CTFBotParams().setBotSkin("HumanMaleA.MercMaleC").setSkillLevel(5).setTeam(0), new CTFBotParams().setBotSkin("HumanMaleA.MercMaleA").setSkillLevel(5).setTeam(0), new CTFBotParams().setBotSkin("HumanFemaleA.MercFemaleA").setSkillLevel(5).setTeam(1), new CTFBotParams().setBotSkin("HumanFemaleA.MercFemaleB").setSkillLevel(5).setTeam(1)});
    }
}

