/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.ctfbot.goals;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.CTFBot;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.Goal;
import java.util.Set;

public class GetHealth
extends Goal {
    protected Item health = null;

    public GetHealth(CTFBot bot) {
        super(bot);
    }

    @Override
    public void perform() {
        this.bot.updateFight();
        if (this.health == null) {
            Set healths = this.bot.getTaboo().filter(this.bot.getItems().getSpawnedItems(ItemType.Category.HEALTH).values());
            double min_distance = Double.MAX_VALUE;
            Item winner = null;
            for (Item item : healths) {
                double dist = item.getLocation().getDistance(this.bot.getInfo().getLocation());
                if (!(dist < min_distance)) continue;
                min_distance = dist;
                winner = item;
            }
            this.health = winner;
        }
        if (this.health == null) {
            return;
        }
        this.bot.getLog().info(String.format("Found health: %s", this.health.toString()));
        if (this.bot.getEnemyFlag() == null || !this.bot.getInfo().getId().equals((Object)this.bot.getEnemyFlag().getHolder())) {
            this.bot.goTo((ILocated)this.health);
        }
    }

    @Override
    public double getPriority() {
        if (!(this.bot.getItems().getAllItems(ItemType.Category.HEALTH).size() <= 0 || this.bot.getInfo().getHealth() >= 20 || this.bot.getEnemyFlag() != null && this.bot.getInfo().getId().equals((Object)this.bot.getEnemyFlag().getHolder()) && this.bot.getInfo().atLocation((ILocated)this.bot.getOurFlagBase(), 5.0))) {
            return 100.0;
        }
        return 0.0;
    }

    @Override
    public boolean hasFailed() {
        return false;
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void abandon() {
    }
}

