/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.ctfbot.goals;

import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.IGoal;
import java.util.Collections;
import java.util.LinkedList;

public class GoalManager {
    protected final LinkedList<IGoal> goals = new LinkedList();
    protected IGoal currentGoal = null;
    protected UT2004Bot bot;

    public GoalManager(UT2004Bot bot) {
        this.bot = bot;
    }

    public boolean addGoal(IGoal goal) {
        if (!this.goals.contains(goal)) {
            this.goals.add(goal);
            return true;
        }
        return false;
    }

    public IGoal executeBestGoal() {
        Collections.sort(this.goals);
        IGoal next_goal = this.goals.peekFirst();
        if (next_goal != this.currentGoal && this.currentGoal != null) {
            this.currentGoal.abandon();
        }
        this.currentGoal = next_goal;
        this.bot.getLog().severe(String.format("Chosen goal pri %.2f: %s", this.currentGoal.getPriority(), this.currentGoal.toString()));
        this.currentGoal.perform();
        return this.currentGoal;
    }

    public IGoal getCurrentGoal() {
        return this.currentGoal;
    }

    public void abandonAllGoals() {
        for (IGoal goal : this.goals) {
            goal.abandon();
        }
    }
}

