/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.ctfbot;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.CTFBot;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.Goal;

public class CloseInOnEnemy
extends Goal {
    protected boolean runningToPlayer = false;

    public CloseInOnEnemy(CTFBot bot) {
        super(bot);
    }

    @Override
    public void perform() {
        this.bot.updateFight();
        Player enemy = this.bot.getEnemy();
        int decentDistance = Math.round(this.bot.getRandom().nextFloat() * 250.0f) + 200;
        if (enemy != null && this.bot.getInfo().getDistance((ILocated)enemy) > (double)decentDistance && !this.runningToPlayer) {
            this.bot.goTo((ILocated)enemy);
            this.runningToPlayer = true;
        }
    }

    @Override
    public double getPriority() {
        Player player = this.bot.getPlayers().getNearestVisibleEnemy();
        if (player == null) {
            return 0.0;
        }
        double distance = this.bot.getInfo().getDistance((ILocated)player) / 50.0;
        return 10.0 - distance;
    }

    @Override
    public boolean hasFailed() {
        return false;
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void abandon() {
        this.bot.getPathExecutor().stop();
        this.runningToPlayer = false;
    }
}

