package cz.cuni.amis.pogamut.ut2004.examples.modularprey;

import cz.cuni.amis.pogamut.sposh.context.UT2004Context;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;

/**
 * Context is a class that funsions like a shared object between all primitives.
 * You may use default {@link UT2004Context} or create custom one, that is extended
 * to fulfill needs of your bot (extended memory, custom map planner and other stuff).
 *
 * Remmeber to call method {@link UT2004Context#initialize() }, otherwise you will
 * end up with uninitialized modules and very likely with {@link NullPointerException}.
 * @author Honza
 */
public class PreyContext extends UT2004Context<UT2004Bot> {
	
	UT2004PathAutoFixer autoFixer;
	
    public PreyContext(UT2004Bot bot) {
        super("PreyContext", bot);
        // IMPORTANT: Various modules of context must be initialized.
        initialize();
        
        // INITIALIZE CUSTOM MODULES
        
        pathExecutor.addStuckDetector(new UT2004TimeStuckDetector(bot, 3000, 10000)); // if the bot does not move for 3 seconds, consider that it is stuck / if bot waits for more than 10 seconds, consider that is is stuck
        pathExecutor.addStuckDetector(new UT2004PositionStuckDetector(bot));          // watch over the position history of the bot, if the bot does not move sufficiently enough, consider that it is stuck
        pathExecutor.addStuckDetector(new UT2004DistanceStuckDetector(bot));          // watch over distances to target
        
        autoFixer = new UT2004PathAutoFixer(bot, pathExecutor, fwMap, navBuilder);
    }
}
