package cz.cuni.amis.pogamut.ut2004.examples.modularprey;

import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.sposh.context.UT2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.utils.collections.MyCollections;

/**
 * Action that causes bot to run around the map looking for medkits.
 * @author Honza
 */
@PrimitiveInfo(name = "runMedkits", description = "Run around the map trying to get spawned medkits and health vials")
public class RunMedkits extends StateAction<UT2004Context, Boolean> {

    public RunMedkits(UT2004Context ctx) {
        super("runMedkits", ctx);
    }

    @Override
    public void init(VariableContext params) {
    }

    @Override
    public Boolean run(VariableContext params) {
        //if (true) return true;
    	
        Item item = ctx.getFwMap().getNearestItem(
        				ctx.getItems().getSpawnedItems(ItemType.Category.HEALTH).values(), 
						ctx.getInfo().getNearestNavPoint()
		  			);
        
        if (item == null) {
                ctx.getLog().severe("No known spawned pickup!");
                ctx.getNavigation().stopNavigation();
                return false;    		
        }

        ctx.getLog().warning("GOING FOR ITEM: " + item);
        ctx.getLog().warning("ITEM VISIBLE:   " + item.isVisible());
        ctx.getNavigation().navigate(item);

        return true;
    }

    @Override
    public void done(VariableContext params) {
    	// We should normally stop navigation here, but we can be interrupted only by "hit-wall" drive
    	// that will cause the bot to JUMP and it will then return here anyway...
    	
    	// Moreover stopping navigation might filter out unreachable spots...
        // ctx.getNavigation().stopNavigation();
    }
}
