package cz.cuni.amis.pogamut.ut2004.examples.modularprey;

import cz.cuni.amis.pogamut.sposh.context.UT2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;

/**
 * Sense for collision of bot with geometry of the level.
 * @author Honza
 */
@PrimitiveInfo(name = "hitWall", description = "Is bot colliding with geometry of the level?")
public class HitWall extends StateSense<UT2004Context, Boolean> {

    public HitWall(UT2004Context ctx) {
        super("hitWall", ctx);
    }

    @Override
    public Boolean query(VariableContext params) {
        return ctx.getSenses().isColliding();
    }
}
