/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.navigationbot;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavPoints;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutorStuckState;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;

@AgentScoped
public class NavigationBot
extends UT2004BotModuleController {
    protected TabooSet<NavPoint> tabooNavPoints;
    protected NavPoint targetNavPoint;
    protected UT2004PathAutoFixer autoFixer;
    protected UT2004Navigation navigationAStar;
    protected int talking;
    @JProp
    public boolean useAStar = false;
    @JProp
    public boolean useNavMesh = true;
    @JProp
    public boolean drawNavMesh = true;
    public boolean shouldSpeak = true;
    public boolean shouldLog = false;
    public Level navigationLogLevel = Level.WARNING;
    protected IUT2004Navigation navigationToUse;
    private boolean navMeshDrawn = false;
    private int waitForMesh;
    private double waitingForMesh;
    private boolean offMeshLinksDrawn = false;
    private int waitForOffMeshLinks;
    private double waitingForOffMeshLinks;

    public Initialize getInitializeCommand() {
        return new Initialize().setName("NavigationBot");
    }

    public void mapInfoObtained() {
        this.navMeshModule.setReloadNavMesh(true);
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.tabooNavPoints = new TabooSet(this.bot);
        this.autoFixer = new UT2004PathAutoFixer(this.bot, this.navigation.getPathExecutor(), this.fwMap, this.aStar, this.navBuilder);
        this.navigation.getPathExecutor().getState().addStrongListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                NavigationBot.this.pathExecutorStateChange(changedValue);
            }
        });
        this.nmNav.getPathExecutor().getState().addStrongListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                NavigationBot.this.pathExecutorStateChange(changedValue);
            }
        });
        this.navigationAStar = new UT2004Navigation(this.bot, this.navigation.getPathExecutor(), (IPathPlanner)this.aStar, this.navigation.getBackToNavGraph(), this.navigation.getRunStraight());
        this.navigationAStar.getLog().setLevel(this.navigationLogLevel);
        this.navigation.getLog().setLevel(this.navigationLogLevel);
        this.nmNav.setLogLevel(this.navigationLogLevel);
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
    }

    public void beforeFirstLogic() {
    }

    public void logic() {
        this.say("--- Logic iteration ---");
        this.chooseNavigationToUse();
        if (this.navigationToUse == this.nmNav && this.drawNavMesh) {
            if (!this.drawNavMesh()) {
                return;
            }
            if (!this.drawOffMeshLinks()) {
                return;
            }
        }
        if (this.players.canSeePlayers() || this.navigationToUse.getCurrentTargetPlayer() != null) {
            this.handlePlayerNavigation();
        } else {
            this.handleNavPointNavigation();
        }
    }

    private void chooseNavigationToUse() {
        if (this.useAStar) {
            if (this.navigationToUse != this.navigationAStar) {
                this.say("Using UT2004AStar to find path.");
                if (this.navigationToUse != null) {
                    this.navigationToUse.stopNavigation();
                }
                this.navigationToUse = this.navigationAStar;
                this.info.getBotName().setInfo("UT2004-ASTAR");
            }
        } else if (this.useNavMesh) {
            if (this.nmNav.isAvailable()) {
                if (this.navigationToUse != this.nmNav) {
                    this.say("Using NavMesh for navigation.");
                    if (this.navigationToUse != null) {
                        this.navigationToUse.stopNavigation();
                    }
                    this.navigationToUse = this.nmNav;
                    this.info.getBotName().setInfo("NAVMESH");
                }
            } else {
                this.log.warning("NavMesh not available! See startup log for more details.");
            }
        }
        if ((this.navigationToUse == null || !this.useAStar && !this.useNavMesh) && this.navigationToUse != this.navigation) {
            this.say("Using FloydWarshallMap to find path.");
            if (this.navigationToUse != null) {
                this.navigationToUse.stopNavigation();
            }
            this.navigationToUse = this.navigation;
            this.info.getBotName().setInfo("FW");
        }
    }

    private void handlePlayerNavigation() {
        if (this.navigationToUse.isNavigating() && this.navigationToUse.getCurrentTargetPlayer() != null) {
            this.logNavigation();
            return;
        }
        Player player = this.players.getNearestVisiblePlayer();
        if (player == null) {
            this.handleNavPointNavigation();
            return;
        }
        if (this.info.getLocation().getDistance(player.getLocation()) < 100.0) {
            this.talkTo(player);
            return;
        }
        this.navigationToUse.navigate(player);
        this.logNavigation();
    }

    private void handleNavPointNavigation() {
        if (this.navigationToUse.isNavigatingToNavPoint()) {
            while (this.navigationToUse.getContinueTo() == null && this.navigationToUse.getRemainingDistance() < 400.0) {
                NavPoint nextNavPoint = this.getRandomNavPoint();
                this.say("EXTENDING THE PATH: " + NavPoints.describe((ILocated)nextNavPoint));
                this.navigationToUse.setContinueTo((ILocated)nextNavPoint);
            }
            this.logNavigation();
            return;
        }
        this.targetNavPoint = this.getRandomNavPoint();
        if (this.targetNavPoint == null) {
            this.log.severe("COULD NOT CHOOSE ANY NAVIGATION POINT TO RUN TO!!!");
            if (this.world.getAll(NavPoint.class).size() == 0) {
                this.log.severe("world.getAll(NavPoint.class).size() == 0, there are no navigation ponits to choose from! Is exporting of nav points enabled in GameBots2004.ini inside UT2004?");
            }
            this.config.setName("NavigationBot [CRASHED]");
            return;
        }
        this.talking = 0;
        this.say("CHOOSING FIRST NAVPOINT TO RUN TO: " + NavPoints.describe((ILocated)this.targetNavPoint));
        this.navigationToUse.navigate((ILocated)this.targetNavPoint);
        this.logNavigation();
    }

    private void logNavigation() {
        if (this.navigationToUse.getCurrentTargetPlayer() != null) {
            this.say("-> " + NavPoints.describe((ILocated)this.navigationToUse.getCurrentTargetPlayer()));
        } else {
            this.say("-> " + NavPoints.describe((ILocated)this.navigationToUse.getCurrentTarget()));
        }
        int pathLeftSize = this.navigationToUse.getPathExecutor().getPath() == null ? 0 : this.navigationToUse.getPathExecutor().getPath().size() - this.navigationToUse.getPathExecutor().getPathElementIndex();
        this.say("Path points left:   " + pathLeftSize);
        this.say("Remaining distance: " + this.navigationToUse.getRemainingDistance());
        this.say("Visible navpoints:  " + this.world.getAllVisible(NavPoint.class).size() + " / " + this.world.getAll(NavPoint.class).size());
        this.say("Visible items:      " + this.items.getVisibleItems().values() + " / " + this.world.getAll(Item.class).size());
        this.say("Visible players:    " + this.players.getVisiblePlayers().size());
    }

    private void talkTo(Player player) {
        this.move.turnTo(player);
        switch (this.talking) {
            case 0: {
                this.say("Hi!");
                break;
            }
            case 4: {
                this.say("Howdy!");
                break;
            }
            case 10: {
                this.say("I'm NavigationBot made to fool around and test Pogamut's navigation stuff!");
                break;
            }
            case 18: {
                this.say("My work is extremely important.");
                break;
            }
            case 24: {
                this.say("So do not interrupt me, ok?");
                break;
            }
            case 26: {
                if (!(this.random.nextDouble() > 0.5)) break;
                this.move.jump();
                break;
            }
            case 40: {
                this.say(this.getRandomLogoutMessage());
            }
        }
        ++this.talking;
        if (this.talking > 40) {
            this.talking = 25;
        }
    }

    private String getRandomLogoutMessage() {
        switch (this.random.nextInt(8)) {
            case 0: {
                return "I would appriciate if you log out or switch to SPECTATE mode.";
            }
            case 1: {
                return "Would you please log out or switch to SPECTATE mode.";
            }
            case 2: {
                return "Just log out, will ya?";
            }
            case 3: {
                return "As I've said, I'M SOMEONE, so log out, ok?";
            }
            case 4: {
                return "I can see you don't get it... LOGOUT! OK!";
            }
            case 5: {
                return "I hate when humans are so clueless... just press ESCAPE key and press Spectate button, that's all I want!";
            }
            case 6: {
                return "I guess you do not know how to switch to spectate mode, right? Just press ESCAPE key and press Spectate button";
            }
        }
        return "AHAHAHAYYYAAAA!";
    }

    private boolean drawNavMesh() {
        if (!this.navMeshDrawn) {
            this.navMeshDrawn = true;
            this.say("Drawing NavMesh...");
            this.navMeshModule.getNavMeshDraw().clearAll();
            this.navMeshModule.getNavMeshDraw().draw(true, false);
            this.say("Okey, drawing commands issued, now we have to wait a bit till it gets drawn completely...");
            this.waitForMesh = this.navMeshModule.getNavMesh().getPolys().size() / 35;
            this.waitingForMesh = -this.info.getTimeDelta();
        }
        if (this.waitForMesh > 0) {
            this.waitForMesh = (int)((double)this.waitForMesh - this.info.getTimeDelta());
            this.waitingForMesh += this.info.getTimeDelta();
            if (this.waitingForMesh > 2.0) {
                this.waitingForMesh = 0.0;
                this.say(Math.round(this.waitForMesh) + "s...");
            }
            if (this.waitForMesh > 0) {
                return false;
            }
        }
        return true;
    }

    private boolean drawOffMeshLinks() {
        if (!this.offMeshLinksDrawn) {
            this.offMeshLinksDrawn = true;
            if (this.navMeshModule.getNavMesh().getOffMeshPoints().size() == 0) {
                this.say("Ha! There are no off-mesh points / links within this map!");
                return true;
            }
            this.say("Drawing OffMesh Links...");
            this.navMeshModule.getNavMeshDraw().draw(false, true);
            this.say("Okey, drawing commands issued, now we have to wait a bit till it gets drawn completely...");
            this.waitForOffMeshLinks = this.navMeshModule.getNavMesh().getOffMeshPoints().size() / 10;
            this.waitingForOffMeshLinks = -this.info.getTimeDelta();
        }
        if (this.waitForOffMeshLinks > 0) {
            this.waitForOffMeshLinks = (int)((double)this.waitForOffMeshLinks - this.info.getTimeDelta());
            this.waitingForOffMeshLinks += this.info.getTimeDelta();
            if (this.waitingForOffMeshLinks > 2.0) {
                this.waitingForOffMeshLinks = 0.0;
                this.say(Math.round(this.waitForOffMeshLinks) + "s...");
            }
            if (this.waitForOffMeshLinks > 0) {
                return false;
            }
        }
        return true;
    }

    private void say(String text) {
        if (this.shouldSpeak) {
            this.body.getCommunication().sendGlobalTextMessage(text);
        }
        if (this.shouldLog) {
            this.say(text);
        }
    }

    public void botKilled(BotKilled event) {
        this.navigation.stopNavigation();
    }

    protected void pathExecutorStateChange(IPathExecutorState event) {
        switch (event.getState()) {
            case PATH_COMPUTATION_FAILED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 180.0);
                break;
            }
            case TARGET_REACHED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 180.0);
                break;
            }
            case STUCK: {
                UT2004PathExecutorStuckState stuck = (UT2004PathExecutorStuckState)event;
                if (stuck.isGlobalTimeout()) {
                    this.say("UT2004PathExecutor GLOBAL TIMEOUT!");
                } else {
                    this.say(stuck.getStuckDetector() + " reported STUCK!");
                }
                if (stuck.getLink() == null) {
                    this.say("STUCK LINK is NOT AVAILABLE!");
                } else {
                    this.say("Bot has stuck while running from " + stuck.getLink().getFromNavPoint().getId() + " -> " + stuck.getLink().getToNavPoint().getId());
                }
                this.tabooNavPoints.add((Object)this.targetNavPoint, 60.0);
                break;
            }
            case STOPPED: {
                this.targetNavPoint = null;
            }
        }
    }

    protected NavPoint getRandomNavPoint() {
        this.say("Picking new target navpoint.");
        NavPoint chosen = (NavPoint)MyCollections.getRandomFiltered(this.getWorldView().getAll(NavPoint.class).values(), this.tabooNavPoints);
        if (chosen != null) {
            return chosen;
        }
        this.log.warning("All navpoints are tabooized at this moment, choosing navpoint randomly!");
        return (NavPoint)MyCollections.getRandom(this.getWorldView().getAll(NavPoint.class).values());
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(NavigationBot.class, "NavigationBot").setMain(true).setLogLevel(Level.WARNING).startAgent();
    }
}

