/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.raycastingbot;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.RemoveRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import javax.vecmath.Vector3d;

@AgentScoped
public class RaycastingBot
extends UT2004BotModuleController {
    protected static final String FRONT = "frontRay";
    protected static final String LEFT45 = "left45Ray";
    protected static final String LEFT90 = "left90Ray";
    protected static final String RIGHT45 = "right45Ray";
    protected static final String RIGHT90 = "right90Ray";
    private AutoTraceRay left;
    private AutoTraceRay front;
    private AutoTraceRay right;
    private boolean first = true;
    private boolean raysInitialized = false;
    @JProp
    private boolean sensorLeft45 = false;
    @JProp
    private boolean sensorRight45 = false;
    @JProp
    private boolean sensorFront = false;
    @JProp
    private boolean moving = false;
    @JProp
    private boolean sensor = false;
    @JProp
    private int turnSleep = 250;
    private float moveSpeed = 0.6f;
    @JProp
    private int smallTurn = 30;
    @JProp
    private int bigTurn = 90;

    public void botInitialized(GameInfo info, ConfigChange currentConfig, InitedMessage init) {
        int rayLength = 250;
        boolean fastTrace = true;
        boolean floorCorrection = false;
        boolean traceActor = false;
        this.getAct().act((CommandMessage)new RemoveRay("All"));
        this.raycasting.createRay(LEFT45, new Vector3d(1.0, -1.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.createRay(FRONT, new Vector3d(1.0, 0.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.createRay(RIGHT45, new Vector3d(1.0, 1.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.createRay(LEFT90, new Vector3d(0.0, -1.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.createRay(RIGHT90, new Vector3d(0.0, 1.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.getAllRaysInitialized().addListener((FlagListener)new FlagListener<Boolean>(){

            public void flagChanged(Boolean changedValue) {
                RaycastingBot.this.left = RaycastingBot.this.raycasting.getRay(RaycastingBot.LEFT45);
                RaycastingBot.this.front = RaycastingBot.this.raycasting.getRay(RaycastingBot.FRONT);
                RaycastingBot.this.right = RaycastingBot.this.raycasting.getRay(RaycastingBot.RIGHT45);
            }
        });
        this.raycasting.endRayInitSequence();
        this.config.setSpeedMultiplier((double)this.moveSpeed);
        this.getAct().act((CommandMessage)new Configuration().setDrawTraceLines(Boolean.valueOf(true)).setAutoTrace(Boolean.valueOf(true)));
    }

    public void logic() throws PogamutException {
        this.log.info("--- Logic iteration ---");
        if (!((Boolean)this.raycasting.getAllRaysInitialized().getFlag()).booleanValue()) {
            return;
        }
        this.sensorFront = this.front.isResult();
        this.sensorLeft45 = this.left.isResult();
        this.sensorRight45 = this.right.isResult();
        boolean bl = this.sensor = this.sensorFront || this.sensorLeft45 || this.sensorRight45;
        if (!this.sensor) {
            this.goForward();
            return;
        }
        if (this.moving) {
            this.move.stopMovement();
            this.moving = false;
        }
        if (this.sensorFront) {
            if (this.sensorLeft45) {
                if (this.sensorRight45) {
                    this.move.turnHorizontal(this.bigTurn);
                } else {
                    this.move.turnHorizontal(this.smallTurn);
                }
            } else if (this.sensorRight45) {
                this.move.turnHorizontal(-this.smallTurn);
            } else {
                this.move.turnHorizontal(this.smallTurn);
            }
        } else if (this.sensorLeft45) {
            if (this.sensorRight45) {
                this.goForward();
            } else {
                this.move.turnHorizontal(this.smallTurn);
            }
        } else if (this.sensorRight45) {
            this.move.turnHorizontal(-this.smallTurn);
        } else {
            this.goForward();
        }
    }

    protected void goForward() {
        this.move.moveContinuos();
        this.moving = true;
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(RaycastingBot.class, "RaycastingBot").setMain(true).startAgent();
    }
}

