/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.controlserver;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.examples.controlserver.CustomControlServerModule;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.utils.exception.PogamutException;

public class CustomControlServer
extends UT2004Server
implements IUT2004Server {
    private double currentUTTime;
    IWorldEventListener<BeginMessage> myBeginMessageListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage event) {
            CustomControlServer.this.currentUTTime = event.getTime();
            System.out.println("Begin: " + event.toString());
        }
    };
    IWorldObjectListener<Player> myPlayerListener = new IWorldObjectListener<Player>(){

        public void notify(IWorldObjectEvent<Player> event) {
            System.out.println("Player: " + ((Player)event.getObject()).toString());
        }
    };

    @Inject
    public CustomControlServer(UT2004AgentParameters params, IAgentLogger agentLogger, IComponentBus bus, SocketConnection connection, UT2004WorldView worldView, IAct act) {
        super(params, agentLogger, bus, connection, worldView, act);
    }

    public void initialize() {
        ((UT2004WorldView)this.getWorldView()).addEventListener(BeginMessage.class, this.myBeginMessageListener);
        ((UT2004WorldView)this.getWorldView()).addObjectListener(Player.class, this.myPlayerListener);
        System.out.println("ControlConnection initialized.");
    }

    public static void main(String[] args) throws PogamutException {
        UT2004AgentParameters params = new UT2004AgentParameters();
        params.setAgentId((IAgentId)new AgentId("ControlConnection"));
        params.setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress("127.0.0.1", 3001));
        CustomControlServerModule module = new CustomControlServerModule();
        UT2004ServerFactory fac = new UT2004ServerFactory((UT2004ServerModule)module);
        CustomControlServer cts = (CustomControlServer)fac.newAgent((IAgentParameters)params);
        cts.start();
        cts.initialize();
    }
}

