/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.hidebot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.Cooldown;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;

@AgentScoped
public class HideBot
extends UT2004BotModuleController {
    protected TabooSet<NavPoint> tabooNavPoints;
    protected UT2004PathAutoFixer autoFixer;
    Player hidingFrom;
    Heatup hiding = new Heatup(10000L);
    Cooldown turning = new Cooldown(1200L);
    NavPoint targetNavPoint;
    Cooldown changeNavPoint = new Cooldown(2000L);

    public Initialize getInitializeCommand() {
        return new Initialize().setName("HideBot");
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.tabooNavPoints = new TabooSet(this.bot);
        this.autoFixer = new UT2004PathAutoFixer(this.bot, this.navigation.getPathExecutor(), this.fwMap, this.aStar, this.navBuilder);
        this.navigation.getPathExecutor().getState().addStrongListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                HideBot.this.pathExecutorStateChange(changedValue.getState());
            }
        });
    }

    public void logic() {
        if (!this.visibility.isInitialized()) {
            this.log.warning("Could not use VISIBILITY module :-(");
            return;
        }
        Player visible = this.players.getNearestVisiblePlayer();
        if (this.hidingFrom != null) {
            if (visible != this.hidingFrom) {
                if (!this.hidingFrom.isVisible()) {
                    this.startRunningAwayFrom(visible);
                    return;
                }
                if (this.info.getLocation().getDistance(visible.getLocation()) < this.info.getLocation().getDistance(this.hidingFrom.getLocation())) {
                    this.startRunningAwayFrom(this.hidingFrom);
                    return;
                }
            }
            this.continueRunningAwayFrom();
            return;
        }
        if (visible != null) {
            this.startRunningAwayFrom(visible);
            return;
        }
        if (this.navigation.isNavigating()) {
            this.navigation.stopNavigation();
            this.navigation.setFocus(null);
        }
        if (this.turning.tryUse()) {
            this.move.turnHorizontal(110);
        }
    }

    private void startRunningAwayFrom(Player enemy) {
        this.hidingFrom = enemy;
        NavPoint cover = this.getCoverNavPoint((ILocated)enemy);
        if (cover == null) {
            this.log.warning("No suitable navpoint, standing still... :-(");
            return;
        }
        this.navigation.setFocus((ILocated)enemy);
        this.runTo(cover);
    }

    private NavPoint getCoverNavPoint(ILocated enemy) {
        Set navPoints = this.visibility.getCoverNavPointsFrom(enemy);
        NavPoint cover = (NavPoint)DistanceUtils.getNearestFiltered((Collection)navPoints, (ILocated)this.info.getLocation(), this.tabooNavPoints);
        if (cover != null) {
            return cover;
        }
        this.log.warning("Could not use any navpoint as cover... trying random one.");
        return this.getRandomNavPoint();
    }

    private void continueRunningAwayFrom() {
        if (this.hidingFrom == null) {
            this.log.warning("hidingFrom == null ???");
            return;
        }
        if (this.navigation.isNavigating()) {
            NavPoint suitableNavPoint = this.getCoverNavPoint((ILocated)this.hidingFrom);
            if (this.targetNavPoint != suitableNavPoint && this.changeNavPoint.tryUse()) {
                this.runTo(suitableNavPoint);
            }
            return;
        }
        if (this.targetNavPoint != null) {
            this.tabooNavPoints.add((Object)this.targetNavPoint, 30.0);
        }
        if (this.hidingFrom.isVisible()) {
            this.startRunningAwayFrom(this.hidingFrom);
            return;
        }
        this.hidingFrom = null;
    }

    private void runTo(NavPoint navPoint) {
        this.log.info("Running to: " + navPoint);
        this.targetNavPoint = navPoint;
        this.navigation.navigate((ILocated)this.targetNavPoint);
    }

    public void botKilled(BotKilled event) {
        this.navigation.stopNavigation();
        this.targetNavPoint = null;
        this.hidingFrom = null;
        this.hiding.clear();
        this.turning.clear();
        this.changeNavPoint.clear();
    }

    protected void pathExecutorStateChange(PathExecutorState state) {
        switch (state) {
            case PATH_COMPUTATION_FAILED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 180.0);
                break;
            }
            case TARGET_REACHED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 5.0);
                break;
            }
            case STUCK: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 60.0);
                break;
            }
            case STOPPED: {
                this.targetNavPoint = null;
            }
        }
    }

    protected NavPoint getRandomNavPoint() {
        this.log.info("Picking new target navpoint.");
        NavPoint chosen = (NavPoint)MyCollections.getRandomFiltered(this.getWorldView().getAll(NavPoint.class).values(), this.tabooNavPoints);
        if (chosen != null) {
            return chosen;
        }
        this.log.warning("All navpoints are tabooized at this moment, choosing navpoint randomly!");
        return (NavPoint)MyCollections.getRandom(this.getWorldView().getAll(NavPoint.class).values());
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(HideBot.class, "HideBot").setMain(true).setLogLevel(Level.INFO).startAgent();
    }
}

