package cz.cuni.amis.pogamut.ut2004.multi.examples.ctfemptybot;

import java.util.logging.Level;
import java.util.logging.Logger;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.AgentDescriptor;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamedAgentId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.utils.MultipleUT2004BotRunner;
import cz.cuni.amis.pogamut.ut2004multi.bot.impl.UT2004BotMultiController;
import cz.cuni.amis.pogamut.ut2004multi.factory.guice.remoteagent.UT2004MultiBotModule;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 * First example featuring bot using {@link UT2004BotMultiController}, it exemplify how to:
 * <ol>
 * <li>create multiple bots belonging to concrete team</li>
 * <li>how to create bot with {@link UT2004BotMultiController}</li>
 * <li>tests correct instantiation of these agents</li>
 * </ol>
 */
@AgentScoped
public class CTFEmptyBot extends UT2004BotMultiController {

	@JProp
    public String stringProp = "Hello bot example";
    @JProp
    public boolean boolProp = true;
    @JProp
    public int intProp = 2;
    @JProp
    public double doubleProp = 1.0;

    /**
     * Initialize all necessary variables here, before the bot actually receives anything
     * from the environment.
     */
    @Override
    public void prepareBot(UT2004Bot bot) {
    }
    
    /**
     * Handshake with GameBots2004 is over - bot has information about the map in its world view.
     * Many agent modules are usable since this method is called.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     */
    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    /**
     * The bot is initilized in the environment - a physical representation of the bot is present in the game.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     * @param self information about the agent
     */
    @Override
    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
    	// Display a welcome message in the game engine
    	// right in the time when the bot appears in the environment, i.e., his body has just been spawned 
    	// into the UT2004 for the first time.    	
        body.getCommunication().sendGlobalTextMessage("Hello world! I am alive!");
        
        // alternatively, you may use getAct() method for issuing arbitrary {@link CommandMessage} for the bot's body
        // inside UT2004
        getAct().act(new SendMessage().setGlobal(true).setText("And I can speak! Hurray!"));
    }
    
    /**
     * This method is called only once right before actual logic() method is called for the first time.
     */
    @Override
    public void beforeFirstLogic() {
    }

    /**
     * Main method that controls the bot - makes decisions what to do next.
     * It is called iteratively by Pogamut engine every time a synchronous batch
     * from the environment is received. This is usually 4 times per second - it
     * is affected by visionTime variable, that can be adjusted in GameBots ini file in
     * UT2004/System folder.
     *
     * @throws cz.cuni.amis.pogamut.base.exceptions.PogamutException
     */
    @Override
    public void logic() throws PogamutException {
        // Log example message this won't be shown in the game, it is just for debugging purposes
    	// The log is written to the console output if the log level is low enough (i.e., at least Level.INFO)
        if (boolProp) {
        	log.info(stringProp + ": still working.");
        }

        // Increment the example property, you should observe in the IDE how 
        // fast it is being incremented
        intProp++;
        
        log.info("SharedKnowledgeDatabase: " + shared);
    }

    /**
     * This method is called when the bot is started either from IDE or from command line.
     *
     * @param args
     */
    public static void main(String args[]) throws PogamutException {
    	Logger.getLogger("Platform").setLevel(Level.ALL);
    	
    	AgentDescriptor descr = new AgentDescriptor<UT2004BotParameters, UT2004BotModule>();
    	
    	//descr.setCount(2);
    	//TeamRemoteAgentParameters param = new TeamRemoteAgentParameters(); 
    	descr.setAgentModule( new UT2004BotModule( CTFEmptyBot.class ) );

    	// BOT 1
    	UT2004BotParameters params = new UT2004BotParameters();
    	params.setAgentId(new AgentId("RED-1"));
    	params.setTeam(AgentInfo.TEAM_RED);
    	
    	// BOT 2    	
    	UT2004BotParameters params2 = new UT2004BotParameters();
    	params2.setAgentId(new AgentId("RED-2"));
    	params2.setTeam(AgentInfo.TEAM_RED);
    	
    	// ADD BOT DESCRIPTORS ... TELLS MultuipleUT2004BotRunner to startup 2 bots
    	descr.addParams(params, params2);
    	
    	new MultipleUT2004BotRunner<UT2004Bot, UT2004BotParameters, UT2004BotModule>("CTFEmptyBot","127.0.0.1",3000)
    		.setLogLevel(Level.WARNING)
    		.setMain(true)
    		.startAgents(descr);
    }
}
