/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.introspection.python;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.introspection.ScriptFolder;
import cz.cuni.amis.introspection.python.PyObjectAdapter;
import cz.cuni.amis.introspection.python.PyObjectPlace;
import cz.cuni.amis.introspection.python.PyObjectWrapper;
import cz.cuni.amis.introspection.python.PyObjectWrappersManager;
import cz.cuni.amis.introspection.python.PyUnsupportedWrapper;
import cz.cuni.amis.introspection.python.PythonInstrospectableProxy;
import cz.cuni.amis.introspection.python.PythonProperty;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.python.core.Py;
import org.python.core.PyObject;

public class PythonEngineFolder
extends ScriptFolder {
    private ScriptEngine engine;

    public PythonEngineFolder(ScriptEngine engine) {
        super("PythonEngine", engine);
        this.engine = engine;
    }

    private ArrayList<PyObjectAdapter> filterEngineVariables(ScriptEngine engine, boolean hasChildren) {
        ScriptContext context = engine.getContext();
        List<Integer> scopes = context.getScopes();
        int scope = scopes.get(0);
        final Bindings bindings = context.getBindings(scope);
        Set entries = bindings.entrySet();
        PyObjectWrapper wrapper = null;
        PyObjectAdapter adapter = null;
        ArrayList<PyObjectAdapter> list = new ArrayList<PyObjectAdapter>();
        for (Map.Entry entry : entries) {
            final String key = (String)entry.getKey();
            Object value = entry.getValue();
            wrapper = PyObjectWrappersManager.getWrapper(value.getClass());
            if (wrapper instanceof PyUnsupportedWrapper || (hasChildren ? !wrapper.hasChildren(value) : wrapper.hasChildren(value))) continue;
            adapter = new PyObjectAdapter(key, new PyObjectPlace(){
                private Bindings b;
                private String k;
                {
                    this.b = bindings2;
                    this.k = string;
                }

                @Override
                public Object get() {
                    try {
                        return this.b.get(this.k);
                    }
                    catch (Exception e) {
                        return Py.None;
                    }
                }

                @Override
                public void set(PyObject newValue) {
                    bindings.put(key, (Object)newValue);
                }
            });
            list.add(adapter);
        }
        return list;
    }

    @Override
    protected Folder[] computeFolders(ScriptEngine object) {
        ArrayList<PyObjectAdapter> adapters = this.filterEngineVariables(object, true);
        Folder[] proxies = new Folder[adapters.size()];
        int i = 0;
        while (i < adapters.size()) {
            proxies[i] = new PythonInstrospectableProxy(adapters.get(i));
            ++i;
        }
        return proxies;
    }

    @Override
    protected Property[] computeProperties(ScriptEngine object) {
        ArrayList<PyObjectAdapter> adapters = this.filterEngineVariables(object, false);
        Property[] proxies = new Property[adapters.size()];
        int i = 0;
        while (i < adapters.size()) {
            proxies[i] = new PythonProperty(adapters.get(i));
            ++i;
        }
        return proxies;
    }

    public static void main(String[] args) {
        Property[] ps;
        Folder[] ips;
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("python");
        try {
            engine.eval(new InputStreamReader(new FileInputStream(String.valueOf(System.getProperty("user.dir")) + "\\src\\cz\\cuni\\pogamut\\introspection\\python\\PythonEngineScriptProxyTest.py")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (ScriptException e) {
            e.printStackTrace();
            System.exit(1);
        }
        PythonEngineFolder intro = new PythonEngineFolder(engine);
        Folder[] folderArray = ips = intro.computeFolders(engine);
        int n = ips.length;
        int n2 = 0;
        while (n2 < n) {
            Folder ip = folderArray[n2];
            System.out.println("Children - " + ip.getName());
            ++n2;
        }
        Property[] propertyArray = ps = intro.computeProperties(engine);
        int n3 = ps.length;
        n = 0;
        while (n < n3) {
            Property p = propertyArray[n];
            try {
                System.out.println(String.valueOf(p.getName()) + " = " + p.getValue().toString());
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            ++n;
        }
    }
}

