/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.impl.EventDrivenWorldView;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import java.util.ArrayList;
import java.util.List;

@AgentScoped
public class LockableWorldView
extends EventDrivenWorldView
implements ILockableWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "LockableWorldViewDependency";
    private Boolean lock = false;
    protected List<IWorldChangeEvent> eventsToProcess = new ArrayList<IWorldChangeEvent>();
    protected boolean lockEvents = false;

    @Inject
    public LockableWorldView(@Named(value="LockableWorldViewDependency") ComponentDependencies dependencies, IComponentBus bus, IAgentLogger log) {
        super(dependencies, bus, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() throws ComponentNotRunningException {
        if (!this.isRunning()) {
            throw new ComponentNotRunningException(this.controller.getState().getFlag(), (Object)this);
        }
        Boolean bl = this.lock;
        synchronized (bl) {
            this.lock = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Boolean bl = this.lock;
        synchronized (bl) {
            this.lock = false;
            for (IWorldChangeEvent event : this.eventsToProcess) {
                super.notify(event);
            }
            this.eventsToProcess.clear();
        }
    }

    @Override
    public boolean isLocked() {
        return this.lock;
    }

    public void setLockEvents(boolean lockEvents) {
        this.lockEvents = lockEvents;
    }

    public boolean isLockEvents() {
        return this.lockEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(IWorldChangeEvent event) {
        if (!this.isRunning()) {
            throw new ComponentNotRunningException(this.controller.getState().getFlag(), (Object)this);
        }
        Boolean bl = this.lock;
        synchronized (bl) {
            if (this.lock.booleanValue()) {
                if (!this.lockEvents && !(event instanceof IWorldObjectUpdatedEvent)) {
                    this.eventsToProcess.add(event);
                } else {
                    super.notify(event);
                }
            }
        }
    }
}

