/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.jmx;

import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogPublisherMBean;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogRecordNotification;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class JMXLogPublisher
extends LogPublisher
implements JMXLogPublisherMBean,
NotificationEmitter {
    ObjectName objectName = null;
    protected NotificationBroadcasterSupport notification = new NotificationBroadcasterSupport(new MBeanNotificationInfo(new String[]{"notifications.pogamut.jmx.logrecord"}, JMXLogRecordNotification.class.getName(), "Allows you to get messages from the logger"));
    protected String categoryName;
    protected long sequenceNumber = 1L;

    public JMXLogPublisher() {
        super(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage();
            }
        });
    }

    public JMXLogPublisher(Formatter formatter) {
        super(formatter);
    }

    public JMXLogPublisher(ObjectName parent, String categoryName) throws MalformedObjectNameException {
        this.categoryName = categoryName;
        this.objectName = JMXLogCategories.getJMXLogCategoryName(parent, categoryName);
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        Formatter actualFormatter = this.formatter;
        if (actualFormatter != null) {
            String message = actualFormatter.format(record);
            this.notification.sendNotification(new JMXLogRecordNotification(this.objectName, this.sequenceNumber++, record.getMillis(), message, record));
        }
    }

    @Override
    public void publish(LogRecord record, String formattedMsg) {
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notification.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.notification.addNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notification.getNotificationInfo();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notification.removeNotificationListener(listener);
    }
}

