/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UT2004ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import java.util.logging.Logger;

public class UT2004Items
extends Items {
    public UT2004Items(UT2004Bot bot, AgentInfo agentInfo, Game game, Weaponry weaponry, Logger log) {
        super(bot, agentInfo, game, weaponry, log);
    }

    @Override
    public boolean isPickable(Item item) {
        if (item.getType() == UT2004ItemType.HEALTH_PACK && this.agentInfo.isHealthy().booleanValue()) {
            return false;
        }
        if (item.getType() == UT2004ItemType.SUPER_HEALTH_PACK && this.agentInfo.isSuperHealthy().booleanValue()) {
            return false;
        }
        if (item.getType() == UT2004ItemType.MINI_HEALTH_PACK && this.agentInfo.isSuperHealthy().booleanValue()) {
            return false;
        }
        if (item.getType() == UT2004ItemType.SHIELD_PACK && this.agentInfo.hasLowArmor().booleanValue()) {
            return false;
        }
        if (item.getType() == UT2004ItemType.SUPER_SHIELD_PACK && this.agentInfo.hasHighArmor().booleanValue()) {
            return false;
        }
        if (item.getType().getCategory() == ItemType.Category.WEAPON) {
            if (this.game.getGameInfo().isWeaponStay()) {
                return !this.weaponry.hasWeapon(item.getType());
            }
            return this.weaponry.getPrimaryWeaponAmmo(item.getType()) < this.weaponry.getWeaponDescriptor(item.getType()).getPriMaxAmount() || this.weaponry.getSecondaryWeaponAmmo(item.getType()) < this.weaponry.getWeaponDescriptor(item.getType()).getSecMaxAmount();
        }
        if (item.getType().getCategory() == ItemType.Category.AMMO && this.weaponry.getAmmo(item.getType()) >= this.weaponry.getMaxAmmo(item.getType())) {
            return false;
        }
        if (item.getType() == UT2004ItemType.ADRENALINE_PACK && this.agentInfo.isAdrenalineFull().booleanValue()) {
            return false;
        }
        return item.getType() != UT2004ItemType.U_DAMAGE_PACK || this.agentInfo.hasUDamage() == false;
    }

    @Override
    public double getItemRespawnTime(ItemType itemType) {
        if (itemType == UT2004ItemType.U_DAMAGE_PACK) {
            return 82.5;
        }
        if (itemType == UT2004ItemType.SUPER_SHIELD_PACK || itemType == UT2004ItemType.SUPER_HEALTH_PACK) {
            return 55.0;
        }
        return 27.5;
    }
}

