/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.utils.HashCode;
import cz.cuni.amis.utils.NullCheck;

public class WeaponPref {
    private ItemType weapon;
    private boolean primary;
    private int hashCode;

    public WeaponPref(ItemType weapon, boolean primary) {
        this.weapon = weapon;
        this.primary = primary;
        NullCheck.check(this.weapon, "weapon");
        if (weapon.getCategory() != ItemType.Category.WEAPON) {
            throw new IllegalArgumentException("passed 'weapon' is not of ItemType.Category.WEAPON but " + weapon.getCategory().toString());
        }
        this.hashCode = new HashCode().add(weapon).add(primary).getHash();
    }

    public WeaponPref(ItemType weapon) {
        this.weapon = weapon;
        this.primary = true;
        NullCheck.check(this.weapon, "weapon");
        if (weapon.getCategory() != ItemType.Category.WEAPON) {
            throw new IllegalArgumentException("passed 'weapon' is not of ItemType.Category.WEAPON but " + weapon.getCategory().toString());
        }
        this.hashCode = new HashCode().add(weapon).add(this.primary).getHash();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeaponPref)) {
            return false;
        }
        WeaponPref pref = (WeaponPref)obj;
        return pref.weapon == this.weapon && pref.primary == this.primary;
    }

    public WeaponPref(Weapon weapon, boolean primary) {
        this.weapon = weapon.getType();
        this.primary = primary;
        NullCheck.check(this.weapon, "weapon");
    }

    public ItemType getWeapon() {
        return this.weapon;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isSecondary() {
        return !this.primary;
    }

    public String toString() {
        return "WeaponPref[type=" + this.weapon.getName() + ", " + (this.primary ? "primary mode" : "secondary mode") + "]";
    }
}

