/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.utils.LinkFlag;
import java.util.Collection;

public class UT2004EdgeChecker {
    private static final double NEAR = 50.0;
    private static final double FLOOR_DIFF = 150.0;
    public static final int BAD_EDGE_FLAG = LinkFlag.FLY.get() | LinkFlag.LADDER.get() | LinkFlag.PROSCRIBED.get() | LinkFlag.SWIM.get() | LinkFlag.PLAYERONLY.get();

    public static boolean checkLink(NavPointNeighbourLink edge) {
        if ((edge.getFlags() & BAD_EDGE_FLAG) != 0) {
            return false;
        }
        if ((edge.getFlags() & LinkFlag.SPECIAL.get()) != 0) {
            if (edge.getToNavPoint().isLiftJumpExit()) {
                return false;
            }
            NavPoint liftCenter = edge.getFromNavPoint();
            if (liftCenter.isLiftCenter()) {
                Collection<NavPointNeighbourLink> liftEdges = liftCenter.getOutgoingEdges().values();
                double bottom = Double.NEGATIVE_INFINITY;
                double top = Double.NEGATIVE_INFINITY;
                for (NavPointNeighbourLink liftEdge : liftEdges) {
                    double toZ = liftEdge.getToNavPoint().getLocation().z;
                    if (bottom == Double.NEGATIVE_INFINITY) {
                        bottom = toZ;
                        continue;
                    }
                    if (toZ < bottom - 50.0) {
                        top = bottom;
                        bottom = toZ;
                        continue;
                    }
                    if (!(toZ > bottom + 150.0) || top != Double.NEGATIVE_INFINITY && !(toZ < top - 50.0)) continue;
                    top = toZ;
                }
                if (edge.getToNavPoint().getLocation().z > top + 150.0) {
                    return false;
                }
            }
            return true;
        }
        if (edge.getNeededJump() != null && edge.getNeededJump().z > 680.0) {
            return false;
        }
        return !edge.getToNavPoint().isLiftJumpExit();
    }
}

