/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import java.io.Serializable;
import java.util.ArrayList;

public class LevelGeometryBSPNode
implements Serializable {
    public LevelGeometry geom;
    public ArrayList<Integer> triangles = new ArrayList();
    public LevelGeometryBSPNode parent;
    public double minX;
    public double maxX;
    public double minY;
    public double maxY;
    public double minZ;
    public double maxZ;
    public int sepDim;
    public double sepVal;
    public LevelGeometryBSPNode left;
    public LevelGeometryBSPNode right;

    public LevelGeometryBSPNode(LevelGeometry geom, LevelGeometryBSPNode parent, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        this.geom = geom;
        this.parent = parent;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
    }

    void build() throws Exception {
        double s;
        double sr;
        if (!this.shouldSplit()) {
            if (this.triangles.size() > this.geom.getNumberOfTrianglesInBiggestLeaf()) {
                this.geom.setBiggestLeafInTree(this);
            }
            ++this.geom.leafCount;
            return;
        }
        double maxLength = 0.0;
        this.sepDim = -1;
        if (this.maxX - this.minX > maxLength) {
            maxLength = this.maxX - this.minX;
            this.sepDim = 0;
            this.sepVal = (this.maxX + this.minX) / 2.0;
        }
        if (this.maxY - this.minY > maxLength) {
            maxLength = this.maxY - this.minY;
            this.sepDim = 1;
            this.sepVal = (this.maxY + this.minY) / 2.0;
        }
        if (this.maxZ - this.minZ > maxLength) {
            maxLength = this.maxZ - this.minZ;
            this.sepDim = 2;
            this.sepVal = (this.maxZ + this.minZ) / 2.0;
        }
        this.left = new LevelGeometryBSPNode(this.geom, this, this.minX, this.sepDim == 0 ? this.sepVal : this.maxX, this.minY, this.sepDim == 1 ? this.sepVal : this.maxY, this.minZ, this.sepDim == 2 ? this.sepVal : this.maxZ);
        this.right = new LevelGeometryBSPNode(this.geom, this, this.sepDim == 0 ? this.sepVal : this.minX, this.maxX, this.sepDim == 1 ? this.sepVal : this.minY, this.maxY, this.sepDim == 2 ? this.sepVal : this.minZ, this.maxZ);
        for (Integer triangleId : this.triangles) {
            int tId = triangleId;
            int[] triangle = this.geom.triangles.get(tId);
            boolean isInLeft = false;
            boolean isInRight = false;
            for (int j = 0; j < 3; ++j) {
                int vId = triangle[j];
                double[] v = this.geom.verts.get(vId);
                if (v[this.sepDim] <= this.sepVal) {
                    isInLeft = true;
                }
                if (!(v[this.sepDim] > this.sepVal)) continue;
                isInRight = true;
            }
            if (isInLeft) {
                this.left.triangles.add(tId);
            }
            if (isInRight) {
                this.right.triangles.add(tId);
            }
            if (isInLeft || isInRight) continue;
            throw new Exception("this triangle is on neither side. That's impossible!");
        }
        double sl = this.left.triangles.size();
        double crossFactor = (sl + (sr = (double)this.right.triangles.size()) - (s = (double)this.triangles.size())) / s;
        if (crossFactor > NavMeshConstants.maxAllowedCrossFactor) {
            this.left = null;
            this.right = null;
            if (this.triangles.size() > this.geom.getNumberOfTrianglesInBiggestLeaf()) {
                this.geom.setBiggestLeafInTree(this);
            }
            ++this.geom.leafCount;
            return;
        }
        this.left.build();
        this.right.build();
    }

    private boolean shouldSplit() {
        return this.triangles.size() > NavMeshConstants.stopSplittingNumberOfTriangles && this.maxX - this.minX > NavMeshConstants.stopSplittingSizeOfOneBlock;
    }

    private double max(double d1, double d2) {
        return d1 > d2 ? d1 : d2;
    }

    void cleanInnerNodes() {
        if (this.left == null && this.right == null) {
            return;
        }
        this.triangles = null;
        if (this.left != null) {
            this.left.cleanInnerNodes();
        }
        if (this.right != null) {
            this.right.cleanInnerNodes();
        }
    }
}

