/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.OffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OffMeshPoint
implements ILocated,
INavMeshAtom,
Serializable {
    private UnrealId navpointId = null;
    private int pId = -1;
    private ArrayList<OffMeshEdge> outgoingEdges = new ArrayList();
    private ArrayList<OffMeshEdge> incomingEdges = new ArrayList();
    private Location location;

    public OffMeshPoint(NavPoint navpoint, int pId) {
        this.navpointId = navpoint.getId();
        this.pId = pId;
        this.location = navpoint.getLocation();
    }

    public UnrealId getNavPointId() {
        return this.navpointId;
    }

    public int getPId() {
        return this.pId;
    }

    public ArrayList<OffMeshEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public ArrayList<OffMeshEdge> getIncomingEdges() {
        return this.incomingEdges;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public List<INavMeshAtom> getNeighbours(NavMesh mesh) {
        ArrayList<INavMeshAtom> neighbours = new ArrayList<INavMeshAtom>();
        if (this.pId >= 0) {
            neighbours.add(new NavMeshPolygon(this.pId));
        }
        for (OffMeshEdge oe : this.outgoingEdges) {
            neighbours.add(oe.getTo());
        }
        return neighbours;
    }

    @Override
    public boolean equals(INavMeshAtom atom) {
        if (atom.getClass() == OffMeshPoint.class) {
            OffMeshPoint op = (OffMeshPoint)atom;
            return op.navpointId.getStringId().equals(this.navpointId.getStringId());
        }
        return false;
    }
}

