/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot;

import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data.RecordType;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.INavigationEvaluationTask;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.NavigationEvaluationRepeatTask;
import java.util.logging.Level;

public class BotNavigationParameters
extends UT2004BotParameters {
    private INavigationEvaluationTask task;

    public BotNavigationParameters(INavigationEvaluationTask task) {
        this.task = task;
    }

    public String getResultPath() {
        return this.task.getResultPath();
    }

    public boolean isOnlyRelevantPaths() {
        return this.task.isOnlyRelevantPaths();
    }

    public int getLimit() {
        return this.task.getLimit();
    }

    public String getPathPlanner() {
        return this.task.getPathPlanner();
    }

    public String getNavigation() {
        return this.task.getNavigation();
    }

    public boolean isRepeatTask() {
        return this.task instanceof NavigationEvaluationRepeatTask;
    }

    public String getRepeatFile() {
        if (!this.isRepeatTask()) {
            return null;
        }
        return ((NavigationEvaluationRepeatTask)this.task).getRepeatFile();
    }

    public int getLimitForCompare() {
        return this.task.getLimit() < 0 ? Integer.MAX_VALUE : this.task.getLimit();
    }

    public String getRecordPath() {
        return String.format("%s_%s_record", this.getNavigation(), this.getPathPlanner());
    }

    public RecordType getRecordType() {
        return this.task.getRecordType();
    }

    public INavigationEvaluationTask getTask() {
        return this.task;
    }

    boolean isPathRecord() {
        return this.task.getRecordType() == RecordType.PATH || this.task.getRecordType() == RecordType.PATH_FAILED;
    }

    boolean isFullRecord() {
        return this.task.getRecordType() == RecordType.FULL || this.task.getRecordType() == RecordType.FULL_FAILED;
    }

    boolean keepOnlyFailedRecords() {
        return this.task.getRecordType() == RecordType.PATH_FAILED || this.task.getRecordType() == RecordType.FULL_FAILED;
    }

    Level getLogLevel() {
        return this.task.getLogLevel();
    }
}

