/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.util.concurrent.TimeUnit;

public class TimeUnitToMillis {
    public static long toMillis(long timeout, TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return timeout * 24L * 60L * 60L * 1000L;
            }
            case HOURS: {
                return timeout * 60L * 60L * 1000L;
            }
            case MINUTES: {
                return timeout * 60L * 1000L;
            }
            case SECONDS: {
                return timeout * 1000L;
            }
            case MILLISECONDS: {
                return timeout;
            }
            case MICROSECONDS: {
                return (long)Math.ceil((double)timeout / 1000.0);
            }
            case NANOSECONDS: {
                return (long)Math.ceil((double)timeout / 1000000.0);
            }
        }
        throw new IllegalArgumentException("unhandled time unit: " + (Object)((Object)unit));
    }
}

