/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.future;

import cz.cuni.amis.utils.exception.PogamutCancellationException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.exception.PogamutTimeoutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import cz.cuni.amis.utils.future.IFuture;
import java.util.concurrent.TimeUnit;

public abstract class RunnableFuture<RESULT>
implements Runnable,
IFuture<RESULT> {
    private Object mutex = new Object();
    private boolean cancelled = false;
    private boolean running = false;
    private Flag<Boolean> done = new Flag<Boolean>(false);
    private RuntimeException exception = null;
    private RESULT result = null;

    protected abstract RESULT process() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            this.running = true;
        }
        try {
            this.result = this.process();
        }
        catch (RuntimeException e) {
            this.exception = e;
        }
        catch (Exception e) {
            this.exception = new RuntimeException(e);
        }
        object = this.mutex;
        synchronized (object) {
            this.running = false;
            this.done.setFlag(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.done.getFlag().booleanValue()) {
                return false;
            }
            if (this.running) {
                return false;
            }
            this.cancelled = true;
        }
        return true;
    }

    private RESULT getResult() {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.cancelled) {
            throw new PogamutCancellationException("request has been cancelled", (Object)this);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RESULT get() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.done.getFlag().booleanValue()) {
                return this.getResult();
            }
        }
        new WaitForFlagChange<Boolean>(this.done, true).await();
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RESULT get(long timeout, TimeUnit unit) throws PogamutInterruptedException, PogamutTimeoutException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.done.getFlag().booleanValue()) {
                return this.getResult();
            }
        }
        new WaitForFlagChange<Boolean>(this.done, true).await(timeout, unit);
        object = this.mutex;
        synchronized (object) {
            if (!this.done.getFlag().booleanValue()) {
                return this.getResult();
            }
            return this.getResult();
        }
    }

    @Override
    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final boolean isDone() {
        return this.done.getFlag();
    }
}

