/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.heap;

import cz.cuni.amis.utils.heap.HeapIterator;
import cz.cuni.amis.utils.heap.IHeap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Heap<NODE>
implements IHeap<NODE> {
    private NODE[] nodes;
    private int count;
    private int items;
    private HashMap<NODE, Integer> references;
    private Comparator<NODE> cmp;

    private void grow() {
        Object[] tempNodes = new Object[this.count * 2];
        for (int i = 0; i <= this.items; ++i) {
            tempNodes[i] = this.nodes[i];
        }
        this.nodes = tempNodes;
        this.count *= 2;
    }

    private int left(int reference) {
        return 2 * reference;
    }

    private int right(int reference) {
        return 2 * reference + 1;
    }

    private int upRef(int reference) {
        return reference / 2;
    }

    private NODE getNode(int reference) {
        while (reference >= this.count) {
            this.grow();
        }
        return this.nodes[reference];
    }

    private int downNode(int reference) {
        NODE currentNode = this.getNode(reference);
        if (currentNode == null) {
            return reference;
        }
        Object leftNode = null;
        Object rightNode = null;
        int way = 0;
        while (true) {
            way = 0;
            leftNode = this.getNode(this.left(reference));
            rightNode = this.getNode(this.right(reference));
            if (leftNode == null && rightNode == null) {
                this.references.put(currentNode, reference);
                return reference;
            }
            if (rightNode == null) {
                way = -1;
            } else if (leftNode == null) {
                way = 1;
            }
            if (way == 0) {
                way = this.cmp.compare(leftNode, rightNode);
            }
            if (way < 0) {
                if (this.cmp.compare(currentNode, leftNode) > 0) {
                    this.nodes[reference] = leftNode;
                    this.references.put(leftNode, new Integer(reference));
                    reference = this.left(reference);
                    this.nodes[reference] = currentNode;
                    continue;
                }
                this.references.put(currentNode, reference);
                return reference;
            }
            if (this.cmp.compare(currentNode, rightNode) <= 0) break;
            this.nodes[reference] = rightNode;
            this.references.put(rightNode, new Integer(reference));
            reference = this.right(reference);
            this.nodes[reference] = currentNode;
        }
        this.references.put(currentNode, reference);
        return reference;
    }

    private int upNode(int reference) {
        if (reference == 1) {
            return reference;
        }
        NODE currentNode = this.getNode(reference);
        if (currentNode == null) {
            return reference;
        }
        Object upNode = null;
        while (reference > 1 && this.cmp.compare(currentNode, upNode = (Object)this.getNode(this.upRef(reference))) < 0) {
            this.nodes[reference] = upNode;
            this.references.put(upNode, reference);
            reference = this.upRef(reference);
        }
        this.nodes[reference] = currentNode;
        this.references.put(currentNode, reference);
        return reference;
    }

    private void initHeap(int capacity) {
        if (capacity < 2) {
            capacity = 2;
        }
        this.nodes = new Object[capacity];
        this.count = capacity;
        this.items = 0;
        this.references = new HashMap(capacity);
    }

    public Heap(Comparator<NODE> comp, int capacity) {
        this.initHeap(capacity);
        this.cmp = comp;
    }

    public Heap(Comparator<NODE> comp) {
        this.initHeap(20);
        this.cmp = comp;
    }

    @Override
    public NODE getMin() {
        return this.nodes[1];
    }

    @Override
    public boolean deleteMin() {
        if (this.items == 0) {
            return false;
        }
        return this.remove(this.nodes[1], 1);
    }

    @Override
    public boolean decreaseKey(NODE arg0) {
        Integer reference = this.references.get(arg0);
        if (reference == null) {
            return this.add(arg0);
        }
        this.upNode(reference);
        return true;
    }

    @Override
    public boolean increaseKey(NODE arg0) {
        Integer reference = this.references.get(arg0);
        if (reference == null) {
            return this.add(arg0);
        }
        this.downNode(reference);
        return true;
    }

    @Override
    public boolean changedKey(NODE arg0) {
        Integer reference = this.references.get(arg0);
        if (reference == null) {
            return this.add(arg0);
        }
        this.upNode(reference);
        this.downNode(reference);
        return true;
    }

    @Override
    public boolean add(NODE arg0) {
        Integer reference = this.references.get(arg0);
        if (reference == null) {
            this.getNode(this.items + 1);
            this.nodes[this.items + 1] = arg0;
            this.upNode(this.items + 1);
            ++this.items;
            return true;
        }
        int tempRef = this.upNode(reference);
        if (tempRef == reference) {
            this.downNode(reference);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection arg0) {
        Iterator iter = arg0.iterator();
        while (iter.hasNext()) {
            this.add((NODE)iter.next());
        }
        return true;
    }

    @Override
    public boolean addAll(NODE[] arg0) {
        boolean ok = true;
        for (int i = 0; i < arg0.length; ++i) {
            ok = this.add(arg0[i]) && ok;
        }
        return ok;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.nodes[i] = null;
        }
        this.references.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.references.containsKey(arg0);
    }

    @Override
    public boolean containsAll(Collection arg0) {
        for (Object node : arg0) {
            if (this.contains(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Object[] arg0) {
        for (int i = 0; i < arg0.length; ++i) {
            if (this.contains(arg0[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.references.isEmpty();
    }

    @Override
    public Iterator<NODE> iterator() {
        return new HeapIterator<NODE>(this.nodes, this.items, this);
    }

    private boolean remove(NODE arg0, int reference) {
        this.references.remove(arg0);
        if (this.items == 1) {
            this.nodes[1] = null;
            this.items = 0;
            return true;
        }
        this.nodes[reference] = this.nodes[this.items];
        this.nodes[this.items] = null;
        --this.items;
        this.downNode(reference);
        return true;
    }

    @Override
    public boolean remove(Object arg0) {
        Integer reference = this.references.get(arg0);
        if (reference == null) {
            return false;
        }
        return this.remove((int)reference);
    }

    @Override
    public boolean removeAll(Collection arg0) {
        Iterator iter = arg0.iterator();
        while (iter.hasNext()) {
            this.remove(iter.next());
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection arg0) {
        for (NODE item : this.references.keySet()) {
            Integer reference = this.references.get(item);
            if (arg0.contains(item)) continue;
            this.remove(item, reference);
        }
        return true;
    }

    @Override
    public int size() {
        return this.items;
    }

    @Override
    public boolean empty() {
        return this.items == 0;
    }

    @Override
    public Object[] toArray() {
        return this.references.keySet().toArray();
    }

    @Override
    public Object[] toArray(Object[] arg0) {
        return this.references.keySet().toArray(arg0);
    }

    @Override
    public Set toSet() {
        return new HashSet<NODE>(this.references.keySet());
    }

    @Override
    public Comparator<NODE> getComparator() {
        return this.cmp;
    }
}

