/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Point2D;
import math.geom2d.Shape2D;
import math.geom2d.UnboundedShapeException;
import math.geom2d.domain.Boundary2D;
import math.geom2d.domain.BoundaryPolyCurve2D;
import math.geom2d.domain.BoundarySet2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LineArc2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.polygon.HRectangle2D;
import math.geom2d.polygon.LinearRing2D;

public class Box2D
implements Cloneable {
    private double xmin = 0.0;
    private double xmax = 0.0;
    private double ymin = 0.0;
    private double ymax = 0.0;

    public Box2D() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Box2D(double x0, double x1, double y0, double y1) {
        this.xmin = Math.min(x0, x1);
        this.xmax = Math.max(x0, x1);
        this.ymin = Math.min(y0, y1);
        this.ymax = Math.max(y0, y1);
    }

    public Box2D(Rectangle2D rect) {
        this(rect.getX(), rect.getX() + rect.getWidth(), rect.getY(), rect.getY() + rect.getHeight());
    }

    public Box2D(Point2D p1, Point2D p2) {
        this(p1.getX(), p2.getX(), p1.getY(), p2.getY());
    }

    public Box2D(Point2D point, double w, double h) {
        this(point.getX(), point.getX() + w, point.getY(), point.getY() + h);
    }

    public static final Box2D create(double xmin, double xmax, double ymin, double ymax) {
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    public static final Box2D create(Point2D p1, Point2D p2) {
        return new Box2D(p1, p2);
    }

    public double getMinX() {
        return this.xmin;
    }

    public double getMinY() {
        return this.ymin;
    }

    public double getMaxX() {
        return this.xmax;
    }

    public double getMaxY() {
        return this.ymax;
    }

    public double getWidth() {
        return this.xmax - this.xmin;
    }

    public double getHeight() {
        return this.ymax - this.ymin;
    }

    public boolean isBounded() {
        if (Double.isInfinite(this.xmin)) {
            return false;
        }
        if (Double.isInfinite(this.ymin)) {
            return false;
        }
        if (Double.isInfinite(this.xmax)) {
            return false;
        }
        return !Double.isInfinite(this.ymax);
    }

    public boolean contains(java.awt.geom.Point2D point) {
        double x = point.getX();
        double y = point.getY();
        if (x < this.xmin) {
            return false;
        }
        if (y < this.ymin) {
            return false;
        }
        if (x > this.xmax) {
            return false;
        }
        return !(y > this.ymax);
    }

    public boolean contains(double x, double y) {
        if (x < this.xmin) {
            return false;
        }
        if (y < this.ymin) {
            return false;
        }
        if (x > this.xmax) {
            return false;
        }
        return !(y > this.ymax);
    }

    public boolean containsBounds(Shape2D shape) {
        if (!shape.isBounded()) {
            return false;
        }
        for (Point2D point : shape.getBoundingBox().getVertices()) {
            if (this.contains(point)) continue;
            return false;
        }
        return true;
    }

    public Collection<StraightLine2D> getClippingLines() {
        ArrayList<StraightLine2D> lines = new ArrayList<StraightLine2D>(4);
        if (!Double.isInfinite(this.ymin) && !Double.isNaN(this.ymin)) {
            lines.add(new StraightLine2D(0.0, this.ymin, 1.0, 0.0));
        }
        if (!Double.isInfinite(this.xmax) && !Double.isNaN(this.xmax)) {
            lines.add(new StraightLine2D(this.xmax, 0.0, 0.0, 1.0));
        }
        if (!Double.isInfinite(this.ymax) && !Double.isNaN(this.ymax)) {
            lines.add(new StraightLine2D(0.0, this.ymax, -1.0, 0.0));
        }
        if (!Double.isInfinite(this.xmin) && !Double.isNaN(this.xmin)) {
            lines.add(new StraightLine2D(this.xmin, 0.0, 0.0, -1.0));
        }
        return lines;
    }

    public Collection<LinearShape2D> getEdges() {
        ArrayList<LinearShape2D> edges = new ArrayList<LinearShape2D>(4);
        if (this.isBounded()) {
            edges.add(new LineSegment2D(this.xmin, this.ymin, this.xmax, this.ymin));
            edges.add(new LineSegment2D(this.xmax, this.ymin, this.xmax, this.ymax));
            edges.add(new LineSegment2D(this.xmax, this.ymax, this.xmin, this.ymax));
            edges.add(new LineSegment2D(this.xmin, this.ymax, this.xmin, this.ymin));
            return edges;
        }
        if (!Double.isInfinite(this.ymin)) {
            if (Double.isInfinite(this.xmin) && Double.isInfinite(this.xmax)) {
                edges.add(new StraightLine2D(0.0, this.ymin, 1.0, 0.0));
            } else if (!Double.isInfinite(this.xmin) && !Double.isInfinite(this.xmax)) {
                edges.add(new LineSegment2D(this.xmin, this.ymin, this.xmax, this.ymin));
            } else {
                edges.add(new LineArc2D(0.0, this.ymin, 1.0, 0.0, this.xmin, this.xmax));
            }
        }
        if (!Double.isInfinite(this.xmax)) {
            if (Double.isInfinite(this.ymin) && Double.isInfinite(this.ymax)) {
                edges.add(new StraightLine2D(this.xmax, 0.0, 0.0, 1.0));
            } else if (!Double.isInfinite(this.ymin) && !Double.isInfinite(this.ymax)) {
                edges.add(new LineSegment2D(this.xmax, this.ymin, this.xmax, this.ymax));
            } else {
                edges.add(new LineArc2D(this.xmax, 0.0, 0.0, 1.0, this.ymin, this.ymax));
            }
        }
        if (!Double.isInfinite(this.ymax)) {
            if (Double.isInfinite(this.xmin) && Double.isInfinite(this.xmax)) {
                edges.add(new StraightLine2D(0.0, this.ymax, 1.0, 0.0));
            } else if (!Double.isInfinite(this.xmin) && !Double.isInfinite(this.xmax)) {
                edges.add(new LineSegment2D(this.xmax, this.ymax, this.xmin, this.ymax));
            } else {
                edges.add(new LineArc2D(0.0, this.ymin, 1.0, 0.0, this.xmin, this.xmax).getReverseCurve());
            }
        }
        if (!Double.isInfinite(this.xmin)) {
            if (Double.isInfinite(this.ymin) && Double.isInfinite(this.ymax)) {
                edges.add(new StraightLine2D(this.xmin, 0.0, 0.0, -1.0));
            } else if (!Double.isInfinite(this.ymin) && !Double.isInfinite(this.ymax)) {
                edges.add(new LineSegment2D(this.xmin, this.ymax, this.xmin, this.ymin));
            } else {
                edges.add(new LineArc2D(this.xmin, 0.0, 0.0, 1.0, this.ymin, this.ymax).getReverseCurve());
            }
        }
        return edges;
    }

    public Boundary2D getBoundary() {
        boolean by1;
        if (this.isBounded()) {
            Point2D[] pts = new Point2D[]{new Point2D(this.xmin, this.ymin), new Point2D(this.xmax, this.ymin), new Point2D(this.xmax, this.ymax), new Point2D(this.xmin, this.ymax)};
            return new LinearRing2D(pts);
        }
        boolean bx0 = !Double.isInfinite(this.xmin);
        boolean bx1 = !Double.isInfinite(this.xmax);
        boolean by0 = !Double.isInfinite(this.ymin);
        boolean bl = by1 = !Double.isInfinite(this.ymax);
        if (!bx0 && !bx1) {
            if (!by0 && !by1) {
                return new BoundarySet2D();
            }
            if (by0 && !by1) {
                return new StraightLine2D(0.0, this.ymin, 1.0, 0.0);
            }
            if (!by0 && by1) {
                return new StraightLine2D(0.0, this.ymax, -1.0, 0.0);
            }
            return new BoundarySet2D<StraightLine2D[]>(new StraightLine2D[]{new StraightLine2D(0.0, this.ymin, 1.0, 0.0), new StraightLine2D(0.0, this.ymax, -1.0, 0.0)});
        }
        if (!by0 && !by1) {
            if (!bx0 && !bx1) {
                return new BoundarySet2D();
            }
            if (bx0 && !bx1) {
                return new StraightLine2D(this.xmin, 0.0, 0.0, -1.0);
            }
            if (!bx0 && bx1) {
                return new StraightLine2D(this.xmax, 0.0, 0.0, 1.0);
            }
            return new BoundarySet2D<StraightLine2D[]>(new StraightLine2D[]{new StraightLine2D(this.xmin, 0.0, 0.0, -1.0), new StraightLine2D(this.xmax, 0.0, 0.0, 1.0)});
        }
        if (bx0 && by0) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new LineArc2D[]{new LineArc2D(this.xmin, this.ymin, 0.0, -1.0, Double.NEGATIVE_INFINITY, 0.0), new LineArc2D(this.xmin, this.ymin, 1.0, 0.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx1 && by0) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new LineArc2D[]{new LineArc2D(this.xmax, this.ymin, 1.0, 0.0, Double.NEGATIVE_INFINITY, 0.0), new LineArc2D(this.xmax, this.ymin, 0.0, 1.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx1 && by1) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new LineArc2D[]{new LineArc2D(this.xmax, this.ymax, 0.0, 1.0, Double.NEGATIVE_INFINITY, 0.0), new LineArc2D(this.xmax, this.ymax, -1.0, 0.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx0 && by1) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new LineArc2D[]{new LineArc2D(this.xmin, this.ymax, -1.0, 0.0, Double.NEGATIVE_INFINITY, 0.0), new LineArc2D(this.xmin, this.ymax, 0.0, -1.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx0) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new AbstractLine2D[]{new LineArc2D(this.xmin, this.ymax, -1.0, 0.0, Double.NEGATIVE_INFINITY, 0.0), new LineSegment2D(this.xmin, this.ymax, this.xmin, this.ymin), new LineArc2D(this.xmin, this.ymin, 1.0, 0.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (bx1) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new AbstractLine2D[]{new LineArc2D(this.xmax, this.ymin, 1.0, 0.0, Double.NEGATIVE_INFINITY, 0.0), new LineSegment2D(this.xmax, this.ymin, this.xmax, this.ymax), new LineArc2D(this.xmax, this.ymax, -1.0, 0.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (by0) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new AbstractLine2D[]{new LineArc2D(this.xmin, this.ymin, 0.0, -1.0, Double.NEGATIVE_INFINITY, 0.0), new LineSegment2D(this.xmin, this.ymin, this.xmax, this.ymin), new LineArc2D(this.xmax, this.ymin, 0.0, 1.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        if (by1) {
            return new BoundaryPolyCurve2D((ContinuousOrientedCurve2D[])new AbstractLine2D[]{new LineArc2D(this.xmax, this.ymax, 0.0, 1.0, Double.NEGATIVE_INFINITY, 0.0), new LineSegment2D(this.xmax, this.ymax, this.xmin, this.ymax), new LineArc2D(this.xmin, this.ymax, 0.0, -1.0, 0.0, Double.POSITIVE_INFINITY)});
        }
        return null;
    }

    public Collection<Point2D> getVertices() {
        boolean by1;
        ArrayList<Point2D> points = new ArrayList<Point2D>(4);
        boolean bx0 = !Double.isInfinite(this.xmin) && !Double.isNaN(this.xmin);
        boolean bx1 = !Double.isInfinite(this.xmax) && !Double.isNaN(this.xmax);
        boolean by0 = !Double.isInfinite(this.ymin) && !Double.isNaN(this.ymin);
        boolean bl = by1 = !Double.isInfinite(this.ymax) && !Double.isNaN(this.ymax);
        if (bx0 && by0) {
            points.add(new Point2D(this.xmin, this.ymin));
        }
        if (bx1 && by0) {
            points.add(new Point2D(this.xmax, this.ymin));
        }
        if (bx0 && by1) {
            points.add(new Point2D(this.xmin, this.ymax));
        }
        if (bx1 && by1) {
            points.add(new Point2D(this.xmax, this.ymax));
        }
        return points;
    }

    public int getVertexNumber() {
        return this.getVertices().size();
    }

    public Box2D union(Box2D box) {
        double xmin = Math.min(this.xmin, box.xmin);
        double xmax = Math.max(this.xmax, box.xmax);
        double ymin = Math.min(this.ymin, box.ymin);
        double ymax = Math.max(this.ymax, box.ymax);
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    public Box2D intersection(Box2D box) {
        double xmin = Math.max(this.xmin, box.xmin);
        double xmax = Math.min(this.xmax, box.xmax);
        double ymin = Math.max(this.ymin, box.ymin);
        double ymax = Math.min(this.ymax, box.ymax);
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    public Box2D merge(Box2D box) {
        this.xmin = Math.min(this.xmin, box.xmin);
        this.xmax = Math.max(this.xmax, box.xmax);
        this.ymin = Math.min(this.ymin, box.ymin);
        this.ymax = Math.max(this.ymax, box.ymax);
        return this;
    }

    public Box2D clip(Box2D box) {
        this.xmin = Math.max(this.xmin, box.xmin);
        this.xmax = Math.min(this.xmax, box.xmax);
        this.ymin = Math.max(this.ymin, box.ymin);
        this.ymax = Math.min(this.ymax, box.ymax);
        return this;
    }

    public Box2D transform(AffineTransform2D trans) {
        if (this.isBounded()) {
            Collection<Point2D> points = this.getVertices();
            double xmin = Double.POSITIVE_INFINITY;
            double xmax = Double.NEGATIVE_INFINITY;
            double ymin = Double.POSITIVE_INFINITY;
            double ymax = Double.NEGATIVE_INFINITY;
            for (Point2D point : points) {
                point = point.transform(trans);
                xmin = Math.min(xmin, point.getX());
                ymin = Math.min(ymin, point.getY());
                xmax = Math.max(xmax, point.getX());
                ymax = Math.max(ymax, point.getY());
            }
            return new Box2D(xmin, xmax, ymin, ymax);
        }
        double xmin = Double.NEGATIVE_INFINITY;
        double xmax = Double.POSITIVE_INFINITY;
        double ymin = Double.NEGATIVE_INFINITY;
        double ymax = Double.POSITIVE_INFINITY;
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    public Rectangle getAsAWTRectangle() {
        int xr = (int)Math.floor(this.xmin);
        int yr = (int)Math.floor(this.ymin);
        int wr = (int)Math.ceil(this.xmax - (double)xr);
        int hr = (int)Math.ceil(this.ymax - (double)yr);
        return new Rectangle(xr, yr, wr, hr);
    }

    public Rectangle2D getAsAWTRectangle2D() {
        return new HRectangle2D(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public HRectangle2D getAsRectangle() {
        return new HRectangle2D(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public void draw(Graphics2D g2) {
        if (!this.isBounded()) {
            throw new UnboundedShapeException();
        }
        this.getBoundary().draw(g2);
    }

    public void fill(Graphics2D g2) {
        if (!this.isBounded()) {
            throw new UnboundedShapeException();
        }
        this.getBoundary().fill(g2);
    }

    public Box2D getBoundingBox() {
        return new Box2D(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY());
    }

    public String toString() {
        return new String("Box2D(" + this.xmin + "," + this.xmax + "," + this.ymin + "," + this.ymax + ")");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Box2D)) {
            return false;
        }
        Box2D box = (Box2D)obj;
        if (Math.abs(box.xmin - this.xmin) > 1.0E-12) {
            return false;
        }
        if (Math.abs(box.ymin - this.ymin) > 1.0E-12) {
            return false;
        }
        if (Math.abs(box.xmax - this.xmax) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(box.ymax - this.ymax) > 1.0E-12);
    }

    public Box2D clone() {
        return new Box2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }
}

