/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.AttributeImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeImpl;

final class AttributeEnumeration
extends AxisIteratorImpl
implements LookaheadIterator {
    private ElementImpl element;
    private NodeTest nodeTest;
    private NodeInfo next;
    private int index;
    private int length;

    public AttributeEnumeration(NodeImpl node, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        if (node.getNodeKind() == 1) {
            this.element = (ElementImpl)node;
            AttributeCollection attlist = this.element.getAttributeList();
            this.index = 0;
            if (nodeTest instanceof NameTest) {
                NameTest test = (NameTest)nodeTest;
                this.index = attlist.getIndexByFingerprint(test.getFingerprint());
                if (this.index < 0) {
                    this.next = null;
                } else {
                    this.next = new AttributeImpl(this.element, this.index);
                    this.index = 0;
                    this.length = 0;
                }
            } else {
                this.index = 0;
                this.length = attlist.getLength();
                this.advance();
            }
        } else {
            this.next = null;
            this.index = 0;
            this.length = 0;
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    private void advance() {
        do {
            if (this.index < this.length) {
                this.next = new AttributeImpl(this.element, this.index);
                ++this.index;
                continue;
            }
            this.next = null;
            return;
        } while (!this.nodeTest.matches(this.next));
    }

    public SequenceIterator getAnother() {
        return new AttributeEnumeration(this.element, this.nodeTest);
    }

    public int getProperties() {
        return 4;
    }
}

